# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.complex_market_data import ComplexMarketData
from lusid.models.complex_market_data_id import ComplexMarketDataId

class ListComplexMarketDataWithMetaDataResponse(BaseModel):
    """
    Wraps a ComplexMarketData object with information that was retrieved from storage with it.  In particular,  the scope that the data was stored in,  and an object identifying the market data in that scope.  # noqa: E501
    """
    scope:  Optional[StrictStr] = Field(None,alias="scope", description="The scope that the listed ComplexMarketData entity is stored in.") 
    market_data_id: Optional[ComplexMarketDataId] = Field(default=None, alias="marketDataId")
    market_data: Optional[ComplexMarketData] = Field(default=None, alias="marketData")
    __properties = ["scope", "marketDataId", "marketData"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ListComplexMarketDataWithMetaDataResponse:
        """Create an instance of ListComplexMarketDataWithMetaDataResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of market_data_id
        if self.market_data_id:
            _dict['marketDataId'] = self.market_data_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of market_data
        if self.market_data:
            _dict['marketData'] = self.market_data.to_dict()
        # set to None if scope (nullable) is None
        # and __fields_set__ contains the field
        if self.scope is None and "scope" in self.__fields_set__:
            _dict['scope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ListComplexMarketDataWithMetaDataResponse:
        """Create an instance of ListComplexMarketDataWithMetaDataResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ListComplexMarketDataWithMetaDataResponse.parse_obj(obj)

        _obj = ListComplexMarketDataWithMetaDataResponse.parse_obj({
            "scope": obj.get("scope"),
            "market_data_id": ComplexMarketDataId.from_dict(obj.get("marketDataId")) if obj.get("marketDataId") is not None else None,
            "market_data": ComplexMarketData.from_dict(obj.get("marketData")) if obj.get("marketData") is not None else None
        })
        return _obj

ListComplexMarketDataWithMetaDataResponse.update_forward_refs()
