# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class LusidEntityDataset(BaseModel):
    """
    Contains the run-time parameters that are appropriate for check definitions  with datasetSchema.type = \"LusidEntity\"  # noqa: E501
    """
    as_at: Optional[datetime] = Field(default=None, description="The asAt date to fetch the data. Nullable. Defaults to latest.", alias="asAt")
    effective_at: Optional[datetime] = Field(default=None, description="The effectiveAt date to fetch the data. Nullable. Defaults to latest.", alias="effectiveAt")
    scope:  StrictStr = Field(...,alias="scope", description="The scope of the entities to check. Required.") 
    as_at_modified_since: Optional[datetime] = Field(default=None, description="Nullable. Filters the dataset for version.asAtModified greater than or equal to this value.", alias="asAtModifiedSince")
    selector_attribute:  StrictStr = Field(...,alias="selectorAttribute", description="An attribute (field name, propertyKey or identifierKey) to use to sub-divide the dataset.") 
    selector_value:  StrictStr = Field(...,alias="selectorValue", description="The value of the above attribute used to sub-divide the dataset.") 
    return_identifier_key:  Optional[StrictStr] = Field(None,alias="returnIdentifierKey", description="The preferred identifier to return for entities with multiple external identifiers.") 
    __properties = ["asAt", "effectiveAt", "scope", "asAtModifiedSince", "selectorAttribute", "selectorValue", "returnIdentifierKey"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LusidEntityDataset:
        """Create an instance of LusidEntityDataset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at is None and "as_at" in self.__fields_set__:
            _dict['asAt'] = None

        # set to None if effective_at (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_at is None and "effective_at" in self.__fields_set__:
            _dict['effectiveAt'] = None

        # set to None if as_at_modified_since (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at_modified_since is None and "as_at_modified_since" in self.__fields_set__:
            _dict['asAtModifiedSince'] = None

        # set to None if return_identifier_key (nullable) is None
        # and __fields_set__ contains the field
        if self.return_identifier_key is None and "return_identifier_key" in self.__fields_set__:
            _dict['returnIdentifierKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LusidEntityDataset:
        """Create an instance of LusidEntityDataset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LusidEntityDataset.parse_obj(obj)

        _obj = LusidEntityDataset.parse_obj({
            "as_at": obj.get("asAt"),
            "effective_at": obj.get("effectiveAt"),
            "scope": obj.get("scope"),
            "as_at_modified_since": obj.get("asAtModifiedSince"),
            "selector_attribute": obj.get("selectorAttribute"),
            "selector_value": obj.get("selectorValue"),
            "return_identifier_key": obj.get("returnIdentifierKey")
        })
        return _obj

LusidEntityDataset.update_forward_refs()
