# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class LusidEntityResult(BaseModel):
    """
    Represents LUSID entity details for a data quality check result  # noqa: E501
    """
    as_at: Optional[datetime] = Field(default=None, description="The as-at timestamp for the entity", alias="asAt")
    effective_at: Optional[datetime] = Field(default=None, description="The effective-at timestamp for the entity", alias="effectiveAt")
    entity_type:  Optional[StrictStr] = Field(None,alias="entityType", description="The type of the LUSID entity") 
    scope:  Optional[StrictStr] = Field(None,alias="scope", description="The scope of the entity") 
    identifier_key:  Optional[StrictStr] = Field(None,alias="identifierKey", description="The identifier key for the entity") 
    identifier_value:  Optional[StrictStr] = Field(None,alias="identifierValue", description="The identifier value for the entity") 
    entity_unique_id:  Optional[StrictStr] = Field(None,alias="entityUniqueId", description="The unique identifier for the entity") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="The display name of the entity") 
    __properties = ["asAt", "effectiveAt", "entityType", "scope", "identifierKey", "identifierValue", "entityUniqueId", "displayName"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LusidEntityResult:
        """Create an instance of LusidEntityResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if entity_type (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_type is None and "entity_type" in self.__fields_set__:
            _dict['entityType'] = None

        # set to None if scope (nullable) is None
        # and __fields_set__ contains the field
        if self.scope is None and "scope" in self.__fields_set__:
            _dict['scope'] = None

        # set to None if identifier_key (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier_key is None and "identifier_key" in self.__fields_set__:
            _dict['identifierKey'] = None

        # set to None if identifier_value (nullable) is None
        # and __fields_set__ contains the field
        if self.identifier_value is None and "identifier_value" in self.__fields_set__:
            _dict['identifierValue'] = None

        # set to None if entity_unique_id (nullable) is None
        # and __fields_set__ contains the field
        if self.entity_unique_id is None and "entity_unique_id" in self.__fields_set__:
            _dict['entityUniqueId'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LusidEntityResult:
        """Create an instance of LusidEntityResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LusidEntityResult.parse_obj(obj)

        _obj = LusidEntityResult.parse_obj({
            "as_at": obj.get("asAt"),
            "effective_at": obj.get("effectiveAt"),
            "entity_type": obj.get("entityType"),
            "scope": obj.get("scope"),
            "identifier_key": obj.get("identifierKey"),
            "identifier_value": obj.get("identifierValue"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "display_name": obj.get("displayName")
        })
        return _obj

LusidEntityResult.update_forward_refs()
