# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class MappedString(BaseModel):
    """
    MappedString
    """
    left_value:  Optional[StrictStr] = Field(None,alias="leftValue") 
    right_value:  Optional[StrictStr] = Field(None,alias="rightValue") 
    mapping_direction:  Optional[StrictStr] = Field(None,alias="mappingDirection") 
    is_case_sensitive: Optional[StrictBool] = Field(default=None, alias="isCaseSensitive")
    __properties = ["leftValue", "rightValue", "mappingDirection", "isCaseSensitive"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MappedString:
        """Create an instance of MappedString from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if left_value (nullable) is None
        # and __fields_set__ contains the field
        if self.left_value is None and "left_value" in self.__fields_set__:
            _dict['leftValue'] = None

        # set to None if right_value (nullable) is None
        # and __fields_set__ contains the field
        if self.right_value is None and "right_value" in self.__fields_set__:
            _dict['rightValue'] = None

        # set to None if mapping_direction (nullable) is None
        # and __fields_set__ contains the field
        if self.mapping_direction is None and "mapping_direction" in self.__fields_set__:
            _dict['mappingDirection'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MappedString:
        """Create an instance of MappedString from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MappedString.parse_obj(obj)

        _obj = MappedString.parse_obj({
            "left_value": obj.get("leftValue"),
            "right_value": obj.get("rightValue"),
            "mapping_direction": obj.get("mappingDirection"),
            "is_case_sensitive": obj.get("isCaseSensitive")
        })
        return _obj

MappedString.update_forward_refs()
