# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class MarkToMarketConventions(BaseModel):
    """
    A set of conventions for mark to market. Mark to market is a method   that values financial instruments based on current market prices,   reflecting their current value, rather than historical cost.  # noqa: E501
    """
    calendar_code:  Optional[StrictStr] = Field(None,alias="calendarCode", description="The calendar to use when generating mark to market cashflows and events.") 
    hour_offset_tenor:  Optional[StrictStr] = Field(None,alias="hourOffsetTenor", description="The hour tenor component of the time offset against the maturity date.  This is an optional field, if a value is provided it must be a positive value between '0hour' and '23hour'.") 
    minute_offset_tenor:  Optional[StrictStr] = Field(None,alias="minuteOffsetTenor", description="The minute tenor component of the time offset against the maturity date.  This is an optional field, if a value is provided it must be a positive value between '0min' and '59min'.") 
    __properties = ["calendarCode", "hourOffsetTenor", "minuteOffsetTenor"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MarkToMarketConventions:
        """Create an instance of MarkToMarketConventions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if calendar_code (nullable) is None
        # and __fields_set__ contains the field
        if self.calendar_code is None and "calendar_code" in self.__fields_set__:
            _dict['calendarCode'] = None

        # set to None if hour_offset_tenor (nullable) is None
        # and __fields_set__ contains the field
        if self.hour_offset_tenor is None and "hour_offset_tenor" in self.__fields_set__:
            _dict['hourOffsetTenor'] = None

        # set to None if minute_offset_tenor (nullable) is None
        # and __fields_set__ contains the field
        if self.minute_offset_tenor is None and "minute_offset_tenor" in self.__fields_set__:
            _dict['minuteOffsetTenor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MarkToMarketConventions:
        """Create an instance of MarkToMarketConventions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MarkToMarketConventions.parse_obj(obj)

        _obj = MarkToMarketConventions.parse_obj({
            "calendar_code": obj.get("calendarCode"),
            "hour_offset_tenor": obj.get("hourOffsetTenor"),
            "minute_offset_tenor": obj.get("minuteOffsetTenor")
        })
        return _obj

MarkToMarketConventions.update_forward_refs()
