# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.resource_id import ResourceId

class MembershipAmendmentRequest(BaseModel):
    """
    MembershipAmendmentRequest
    """
    custom_data_model_id: ResourceId = Field(alias="customDataModelId")
    entity_type:  StrictStr = Field(...,alias="entityType", description="The type of the entity that is being added or removed from the Custom Data Model.") 
    entity_unique_id:  StrictStr = Field(...,alias="entityUniqueId", description="The entity unique identifier of the entity that is being added or removed from the Custom Data Model.") 
    operation:  StrictStr = Field(...,alias="operation", description="The operation to be performed on the entity's membership in the Custom Data Model. Either 'Add' or 'Remove'.") 
    __properties = ["customDataModelId", "entityType", "entityUniqueId", "operation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MembershipAmendmentRequest:
        """Create an instance of MembershipAmendmentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of custom_data_model_id
        if self.custom_data_model_id:
            _dict['customDataModelId'] = self.custom_data_model_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MembershipAmendmentRequest:
        """Create an instance of MembershipAmendmentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MembershipAmendmentRequest.parse_obj(obj)

        _obj = MembershipAmendmentRequest.parse_obj({
            "custom_data_model_id": ResourceId.from_dict(obj.get("customDataModelId")) if obj.get("customDataModelId") is not None else None,
            "entity_type": obj.get("entityType"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "operation": obj.get("operation")
        })
        return _obj

MembershipAmendmentRequest.update_forward_refs()
