# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.block import Block
from lusid.models.order import Order
from lusid.models.resource_id import ResourceId

class MovedOrderToDifferentBlockResponse(BaseModel):
    """
    MovedOrderToDifferentBlockResponse
    """
    destination_block: Optional[Block] = Field(default=None, alias="destinationBlock")
    order: Optional[Order] = None
    source_block_id: Optional[ResourceId] = Field(default=None, alias="sourceBlockId")
    __properties = ["destinationBlock", "order", "sourceBlockId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MovedOrderToDifferentBlockResponse:
        """Create an instance of MovedOrderToDifferentBlockResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of destination_block
        if self.destination_block:
            _dict['destinationBlock'] = self.destination_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order
        if self.order:
            _dict['order'] = self.order.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_block_id
        if self.source_block_id:
            _dict['sourceBlockId'] = self.source_block_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MovedOrderToDifferentBlockResponse:
        """Create an instance of MovedOrderToDifferentBlockResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MovedOrderToDifferentBlockResponse.parse_obj(obj)

        _obj = MovedOrderToDifferentBlockResponse.parse_obj({
            "destination_block": Block.from_dict(obj.get("destinationBlock")) if obj.get("destinationBlock") is not None else None,
            "order": Order.from_dict(obj.get("order")) if obj.get("order") is not None else None,
            "source_block_id": ResourceId.from_dict(obj.get("sourceBlockId")) if obj.get("sourceBlockId") is not None else None
        })
        return _obj

MovedOrderToDifferentBlockResponse.update_forward_refs()
