# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.block import Block
from lusid.models.order_graph_block_allocation_synopsis import OrderGraphBlockAllocationSynopsis
from lusid.models.order_graph_block_execution_synopsis import OrderGraphBlockExecutionSynopsis
from lusid.models.order_graph_block_order_synopsis import OrderGraphBlockOrderSynopsis
from lusid.models.order_graph_block_placement_synopsis import OrderGraphBlockPlacementSynopsis
from lusid.models.order_graph_block_transaction_synopsis import OrderGraphBlockTransactionSynopsis

class OrderGraphBlock(BaseModel):
    """
    OrderGraphBlock
    """
    block: Block
    ordered: OrderGraphBlockOrderSynopsis
    placed: OrderGraphBlockPlacementSynopsis
    executed: OrderGraphBlockExecutionSynopsis
    allocated: OrderGraphBlockAllocationSynopsis
    booked: OrderGraphBlockTransactionSynopsis
    derived_state:  StrictStr = Field(...,alias="derivedState", description="A simple description of the overall state of a block.") 
    derived_compliance_state:  StrictStr = Field(...,alias="derivedComplianceState", description="The overall compliance state of a block, derived from the block's orders. Possible values are 'Pending', 'Failed', 'Manually approved' and 'Passed'.") 
    derived_approval_state:  StrictStr = Field(...,alias="derivedApprovalState", description="The overall approval state of a block, derived from approval of the block's orders. Possible values are 'Pending', 'Approved' and 'Rejected'.") 
    __properties = ["block", "ordered", "placed", "executed", "allocated", "booked", "derivedState", "derivedComplianceState", "derivedApprovalState"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderGraphBlock:
        """Create an instance of OrderGraphBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of block
        if self.block:
            _dict['block'] = self.block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ordered
        if self.ordered:
            _dict['ordered'] = self.ordered.to_dict()
        # override the default output from pydantic by calling `to_dict()` of placed
        if self.placed:
            _dict['placed'] = self.placed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of executed
        if self.executed:
            _dict['executed'] = self.executed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allocated
        if self.allocated:
            _dict['allocated'] = self.allocated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of booked
        if self.booked:
            _dict['booked'] = self.booked.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderGraphBlock:
        """Create an instance of OrderGraphBlock from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrderGraphBlock.parse_obj(obj)

        _obj = OrderGraphBlock.parse_obj({
            "block": Block.from_dict(obj.get("block")) if obj.get("block") is not None else None,
            "ordered": OrderGraphBlockOrderSynopsis.from_dict(obj.get("ordered")) if obj.get("ordered") is not None else None,
            "placed": OrderGraphBlockPlacementSynopsis.from_dict(obj.get("placed")) if obj.get("placed") is not None else None,
            "executed": OrderGraphBlockExecutionSynopsis.from_dict(obj.get("executed")) if obj.get("executed") is not None else None,
            "allocated": OrderGraphBlockAllocationSynopsis.from_dict(obj.get("allocated")) if obj.get("allocated") is not None else None,
            "booked": OrderGraphBlockTransactionSynopsis.from_dict(obj.get("booked")) if obj.get("booked") is not None else None,
            "derived_state": obj.get("derivedState"),
            "derived_compliance_state": obj.get("derivedComplianceState"),
            "derived_approval_state": obj.get("derivedApprovalState")
        })
        return _obj

OrderGraphBlock.update_forward_refs()
