# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.order_graph_placement_allocation_synopsis import OrderGraphPlacementAllocationSynopsis
from lusid.models.order_graph_placement_execution_synopsis import OrderGraphPlacementExecutionSynopsis
from lusid.models.order_graph_placement_order_synopsis import OrderGraphPlacementOrderSynopsis
from lusid.models.order_graph_placement_placement_synopsis import OrderGraphPlacementPlacementSynopsis
from lusid.models.placement import Placement
from lusid.models.resource_id import ResourceId

class OrderGraphPlacement(BaseModel):
    """
    OrderGraphPlacement
    """
    placement: Placement
    block_id: ResourceId = Field(alias="blockId")
    ordered: OrderGraphPlacementOrderSynopsis
    placed: OrderGraphPlacementPlacementSynopsis
    executed: OrderGraphPlacementExecutionSynopsis
    allocated: OrderGraphPlacementAllocationSynopsis
    derived_state:  StrictStr = Field(...,alias="derivedState", description="A simple description of the overall state of a placement.") 
    calculated_average_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average price realised on executions for a given placement", alias="calculatedAveragePrice")
    __properties = ["placement", "blockId", "ordered", "placed", "executed", "allocated", "derivedState", "calculatedAveragePrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderGraphPlacement:
        """Create an instance of OrderGraphPlacement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of placement
        if self.placement:
            _dict['placement'] = self.placement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of block_id
        if self.block_id:
            _dict['blockId'] = self.block_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ordered
        if self.ordered:
            _dict['ordered'] = self.ordered.to_dict()
        # override the default output from pydantic by calling `to_dict()` of placed
        if self.placed:
            _dict['placed'] = self.placed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of executed
        if self.executed:
            _dict['executed'] = self.executed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allocated
        if self.allocated:
            _dict['allocated'] = self.allocated.to_dict()
        # set to None if calculated_average_price (nullable) is None
        # and __fields_set__ contains the field
        if self.calculated_average_price is None and "calculated_average_price" in self.__fields_set__:
            _dict['calculatedAveragePrice'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderGraphPlacement:
        """Create an instance of OrderGraphPlacement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrderGraphPlacement.parse_obj(obj)

        _obj = OrderGraphPlacement.parse_obj({
            "placement": Placement.from_dict(obj.get("placement")) if obj.get("placement") is not None else None,
            "block_id": ResourceId.from_dict(obj.get("blockId")) if obj.get("blockId") is not None else None,
            "ordered": OrderGraphPlacementOrderSynopsis.from_dict(obj.get("ordered")) if obj.get("ordered") is not None else None,
            "placed": OrderGraphPlacementPlacementSynopsis.from_dict(obj.get("placed")) if obj.get("placed") is not None else None,
            "executed": OrderGraphPlacementExecutionSynopsis.from_dict(obj.get("executed")) if obj.get("executed") is not None else None,
            "allocated": OrderGraphPlacementAllocationSynopsis.from_dict(obj.get("allocated")) if obj.get("allocated") is not None else None,
            "derived_state": obj.get("derivedState"),
            "calculated_average_price": obj.get("calculatedAveragePrice")
        })
        return _obj

OrderGraphPlacement.update_forward_refs()
