# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.new_instrument import NewInstrument

class PartialClosureConstituent(BaseModel):
    """
    A single constituent of a partial closure event for a Flexible Repo. Contains details of the collateral  being exchanged in the Instrument field, represented as a NewInstrument object,  as well as the amount being exchanged and the type of that amount (Units or Percentage of current units).  # noqa: E501
    """
    amount: Union[StrictFloat, StrictInt] = Field(description="If AmountType is set to Units, this field represents the number of units of the instrument being exchanged.  If AmountType is set to Percentage, this field represents the percentage of the total repoed units of the instrument being exchanged.  When defining a FlexibleRepoPartialClosureEvent the AmountType can be set to either Units or Percentage,  where Units represents the number of units of the instrument being exchanged, and Percentage represents the  percentage of the total repoed units of the instrument being exchanged in the context of the FlexibleRepo.")
    amount_type:  StrictStr = Field(...,alias="amountType", description="The type of amount represented by the Amount field.  I.e., does it represent a number of units or a percentage of the total repoed units of the instrument?  When defining a FlexibleRepoPartialClosureEvent AmountType can be set to either Units or Percentage.    Supported string (enumeration) values are: [Percentage, Units].") 
    instrument: NewInstrument
    __properties = ["amount", "amountType", "instrument"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PartialClosureConstituent:
        """Create an instance of PartialClosureConstituent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of instrument
        if self.instrument:
            _dict['instrument'] = self.instrument.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PartialClosureConstituent:
        """Create an instance of PartialClosureConstituent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PartialClosureConstituent.parse_obj(obj)

        _obj = PartialClosureConstituent.parse_obj({
            "amount": obj.get("amount"),
            "amount_type": obj.get("amountType"),
            "instrument": NewInstrument.from_dict(obj.get("instrument")) if obj.get("instrument") is not None else None
        })
        return _obj

PartialClosureConstituent.update_forward_refs()
