# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.journal_entry_line import JournalEntryLine
from lusid.models.link import Link

class PnlJournalEntryLine(BaseModel):
    """
    PnlJournalEntryLine
    """
    pnl_bucket:  Optional[StrictStr] = Field(None,alias="pnlBucket", description="The Filter ID of the grouping used from the Fund Configuration PnL filters") 
    journal_entry_line: Optional[JournalEntryLine] = Field(default=None, alias="journalEntryLine")
    links: Optional[List[Link]] = None
    __properties = ["pnlBucket", "journalEntryLine", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PnlJournalEntryLine:
        """Create an instance of PnlJournalEntryLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of journal_entry_line
        if self.journal_entry_line:
            _dict['journalEntryLine'] = self.journal_entry_line.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if pnl_bucket (nullable) is None
        # and __fields_set__ contains the field
        if self.pnl_bucket is None and "pnl_bucket" in self.__fields_set__:
            _dict['pnlBucket'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PnlJournalEntryLine:
        """Create an instance of PnlJournalEntryLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PnlJournalEntryLine.parse_obj(obj)

        _obj = PnlJournalEntryLine.parse_obj({
            "pnl_bucket": obj.get("pnlBucket"),
            "journal_entry_line": JournalEntryLine.from_dict(obj.get("journalEntryLine")) if obj.get("journalEntryLine") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

PnlJournalEntryLine.update_forward_refs()
