# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.currency_and_amount import CurrencyAndAmount
from lusid.models.link import Link
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.transaction import Transaction

class PortfolioCashFlow(BaseModel):
    """
    The details for the cashflow for a given portfolio.  # noqa: E501
    """
    group_by_id: StrictInt = Field(description="The groupBy subHoldings and currency.", alias="groupById")
    sequence_number: StrictInt = Field(description="Sequence number determining the order of the cash flow records.", alias="sequenceNumber")
    effective_date: Optional[datetime] = Field(default=None, description="Indicates the date when the cash-flow settles.", alias="effectiveDate")
    sub_holding_keys: Optional[Dict[str, PerpetualProperty]] = Field(default=None, description="The sub-holding properties which identify the holding. Each property will be from the 'Transaction' domain. These are configured on a transaction portfolio.", alias="subHoldingKeys")
    type:  StrictStr = Field(...,alias="type", description="Indicates the record type (Closed, Open, Activity).") 
    movement_name:  StrictStr = Field(...,alias="movementName", description="Indicates the specific movement of the transaction that generated this cash flow.") 
    cashflow: CurrencyAndAmount
    balance: CurrencyAndAmount
    fx_rate: Union[StrictFloat, StrictInt] = Field(description="Exchange rate between the currency of this cash flow and the reporting currency.", alias="fxRate")
    cashflow_reporting_currency: CurrencyAndAmount = Field(alias="cashflowReportingCurrency")
    balance_reporting_currency: CurrencyAndAmount = Field(alias="balanceReportingCurrency")
    translation_gain_loss: CurrencyAndAmount = Field(alias="translationGainLoss")
    cost_basis_reporting_currency: CurrencyAndAmount = Field(alias="costBasisReportingCurrency")
    transaction: Optional[Transaction] = None
    unrealised_gain_loss_reporting_currency: CurrencyAndAmount = Field(alias="unrealisedGainLossReportingCurrency")
    links: Optional[List[Link]] = None
    __properties = ["groupById", "sequenceNumber", "effectiveDate", "subHoldingKeys", "type", "movementName", "cashflow", "balance", "fxRate", "cashflowReportingCurrency", "balanceReportingCurrency", "translationGainLoss", "costBasisReportingCurrency", "transaction", "unrealisedGainLossReportingCurrency", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PortfolioCashFlow:
        """Create an instance of PortfolioCashFlow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in sub_holding_keys (dict)
        _field_dict = {}
        if self.sub_holding_keys:
            for _key in self.sub_holding_keys:
                if self.sub_holding_keys[_key]:
                    _field_dict[_key] = self.sub_holding_keys[_key].to_dict()
            _dict['subHoldingKeys'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of cashflow
        if self.cashflow:
            _dict['cashflow'] = self.cashflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance
        if self.balance:
            _dict['balance'] = self.balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cashflow_reporting_currency
        if self.cashflow_reporting_currency:
            _dict['cashflowReportingCurrency'] = self.cashflow_reporting_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance_reporting_currency
        if self.balance_reporting_currency:
            _dict['balanceReportingCurrency'] = self.balance_reporting_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of translation_gain_loss
        if self.translation_gain_loss:
            _dict['translationGainLoss'] = self.translation_gain_loss.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_basis_reporting_currency
        if self.cost_basis_reporting_currency:
            _dict['costBasisReportingCurrency'] = self.cost_basis_reporting_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction
        if self.transaction:
            _dict['transaction'] = self.transaction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unrealised_gain_loss_reporting_currency
        if self.unrealised_gain_loss_reporting_currency:
            _dict['unrealisedGainLossReportingCurrency'] = self.unrealised_gain_loss_reporting_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if sub_holding_keys (nullable) is None
        # and __fields_set__ contains the field
        if self.sub_holding_keys is None and "sub_holding_keys" in self.__fields_set__:
            _dict['subHoldingKeys'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PortfolioCashFlow:
        """Create an instance of PortfolioCashFlow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PortfolioCashFlow.parse_obj(obj)

        _obj = PortfolioCashFlow.parse_obj({
            "group_by_id": obj.get("groupById"),
            "sequence_number": obj.get("sequenceNumber"),
            "effective_date": obj.get("effectiveDate"),
            "sub_holding_keys": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("subHoldingKeys").items()
            )
            if obj.get("subHoldingKeys") is not None
            else None,
            "type": obj.get("type"),
            "movement_name": obj.get("movementName"),
            "cashflow": CurrencyAndAmount.from_dict(obj.get("cashflow")) if obj.get("cashflow") is not None else None,
            "balance": CurrencyAndAmount.from_dict(obj.get("balance")) if obj.get("balance") is not None else None,
            "fx_rate": obj.get("fxRate"),
            "cashflow_reporting_currency": CurrencyAndAmount.from_dict(obj.get("cashflowReportingCurrency")) if obj.get("cashflowReportingCurrency") is not None else None,
            "balance_reporting_currency": CurrencyAndAmount.from_dict(obj.get("balanceReportingCurrency")) if obj.get("balanceReportingCurrency") is not None else None,
            "translation_gain_loss": CurrencyAndAmount.from_dict(obj.get("translationGainLoss")) if obj.get("translationGainLoss") is not None else None,
            "cost_basis_reporting_currency": CurrencyAndAmount.from_dict(obj.get("costBasisReportingCurrency")) if obj.get("costBasisReportingCurrency") is not None else None,
            "transaction": Transaction.from_dict(obj.get("transaction")) if obj.get("transaction") is not None else None,
            "unrealised_gain_loss_reporting_currency": CurrencyAndAmount.from_dict(obj.get("unrealisedGainLossReportingCurrency")) if obj.get("unrealisedGainLossReportingCurrency") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

PortfolioCashFlow.update_forward_refs()
