# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.settlement_configuration_category import SettlementConfigurationCategory
from lusid.models.transaction_matching_alternative_id import TransactionMatchingAlternativeId

class PortfolioSettlementConfiguration(BaseModel):
    """
    PortfolioSettlementConfiguration
    """
    stock_settlement: Optional[SettlementConfigurationCategory] = Field(default=None, alias="stockSettlement")
    cash_settlement: Optional[SettlementConfigurationCategory] = Field(default=None, alias="cashSettlement")
    deferred_cash_receipt: Optional[SettlementConfigurationCategory] = Field(default=None, alias="deferredCashReceipt")
    transaction_matching_alternative_id: Optional[TransactionMatchingAlternativeId] = Field(default=None, alias="transactionMatchingAlternativeId")
    __properties = ["stockSettlement", "cashSettlement", "deferredCashReceipt", "transactionMatchingAlternativeId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PortfolioSettlementConfiguration:
        """Create an instance of PortfolioSettlementConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of stock_settlement
        if self.stock_settlement:
            _dict['stockSettlement'] = self.stock_settlement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cash_settlement
        if self.cash_settlement:
            _dict['cashSettlement'] = self.cash_settlement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deferred_cash_receipt
        if self.deferred_cash_receipt:
            _dict['deferredCashReceipt'] = self.deferred_cash_receipt.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_matching_alternative_id
        if self.transaction_matching_alternative_id:
            _dict['transactionMatchingAlternativeId'] = self.transaction_matching_alternative_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PortfolioSettlementConfiguration:
        """Create an instance of PortfolioSettlementConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PortfolioSettlementConfiguration.parse_obj(obj)

        _obj = PortfolioSettlementConfiguration.parse_obj({
            "stock_settlement": SettlementConfigurationCategory.from_dict(obj.get("stockSettlement")) if obj.get("stockSettlement") is not None else None,
            "cash_settlement": SettlementConfigurationCategory.from_dict(obj.get("cashSettlement")) if obj.get("cashSettlement") is not None else None,
            "deferred_cash_receipt": SettlementConfigurationCategory.from_dict(obj.get("deferredCashReceipt")) if obj.get("deferredCashReceipt") is not None else None,
            "transaction_matching_alternative_id": TransactionMatchingAlternativeId.from_dict(obj.get("transactionMatchingAlternativeId")) if obj.get("transactionMatchingAlternativeId") is not None else None
        })
        return _obj

PortfolioSettlementConfiguration.update_forward_refs()
