# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class PreviousFundCalendarEntry(BaseModel):
    """
    PreviousFundCalendarEntry
    """
    code:  StrictStr = Field(...,alias="code", description="The unique Code of the Calendar Entry. The Calendar Entry, together with the Fund Scope and Code, uniquely identifies a Fund Calendar Entry") 
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the Fund Calendar entry.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description for the Fund Calendar entry.") 
    effective_at: Optional[datetime] = Field(default=None, description="The effective at of the Calendar Entry.", alias="effectiveAt")
    as_at: datetime = Field(description="The asAt datetime for the Calendar Entry.", alias="asAt")
    __properties = ["code", "displayName", "description", "effectiveAt", "asAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PreviousFundCalendarEntry:
        """Create an instance of PreviousFundCalendarEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PreviousFundCalendarEntry:
        """Create an instance of PreviousFundCalendarEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PreviousFundCalendarEntry.parse_obj(obj)

        _obj = PreviousFundCalendarEntry.parse_obj({
            "code": obj.get("code"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "effective_at": obj.get("effectiveAt"),
            "as_at": obj.get("asAt")
        })
        return _obj

PreviousFundCalendarEntry.update_forward_refs()
