# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.portfolio_entity_id import PortfolioEntityId
from lusid.models.resource_id import ResourceId

class QueryApplicableInstrumentEventsRequest(BaseModel):
    """
    QueryApplicableInstrumentEventsRequest
    """
    window_start: datetime = Field(description="The start date of the window.", alias="windowStart")
    window_end: datetime = Field(description="The end date of the window.", alias="windowEnd")
    effective_at: datetime = Field(description="The Effective date that splits query window into two parts: factual period and forecast period", alias="effectiveAt")
    portfolio_entity_ids: List[PortfolioEntityId] = Field(description="The set of portfolios and portfolio groups to which the instrument events must belong.", alias="portfolioEntityIds")
    forecasting_recipe_id: ResourceId = Field(alias="forecastingRecipeId")
    __properties = ["windowStart", "windowEnd", "effectiveAt", "portfolioEntityIds", "forecastingRecipeId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QueryApplicableInstrumentEventsRequest:
        """Create an instance of QueryApplicableInstrumentEventsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in portfolio_entity_ids (list)
        _items = []
        if self.portfolio_entity_ids:
            for _item in self.portfolio_entity_ids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['portfolioEntityIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of forecasting_recipe_id
        if self.forecasting_recipe_id:
            _dict['forecastingRecipeId'] = self.forecasting_recipe_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QueryApplicableInstrumentEventsRequest:
        """Create an instance of QueryApplicableInstrumentEventsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QueryApplicableInstrumentEventsRequest.parse_obj(obj)

        _obj = QueryApplicableInstrumentEventsRequest.parse_obj({
            "window_start": obj.get("windowStart"),
            "window_end": obj.get("windowEnd"),
            "effective_at": obj.get("effectiveAt"),
            "portfolio_entity_ids": [PortfolioEntityId.from_dict(_item) for _item in obj.get("portfolioEntityIds")] if obj.get("portfolioEntityIds") is not None else None,
            "forecasting_recipe_id": ResourceId.from_dict(obj.get("forecastingRecipeId")) if obj.get("forecastingRecipeId") is not None else None
        })
        return _obj

QueryApplicableInstrumentEventsRequest.update_forward_refs()
