# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class QuoteAccessMetadataRuleId(BaseModel):
    """
    An identifier that uniquely identifies a set of Quote access control metadata.  # noqa: E501
    """
    provider:  Optional[StrictStr] = Field(None,alias="provider", description="The platform or vendor that provided the quote. The available values are: Client, DataScope, Lusid, Edi, TraderMade, FactSet, SIX, Bloomberg, Rimes, ICE, LSEG") 
    price_source:  Optional[StrictStr] = Field(None,alias="priceSource", description="The source or originator of the quote, e.g. a bank or financial institution.") 
    instrument_id:  Optional[StrictStr] = Field(None,alias="instrumentId", description="The value of the instrument identifier that uniquely identifies the instrument that the quote is for, e.g. 'BBG00JX0P539'.") 
    instrument_id_type:  Optional[StrictStr] = Field(None,alias="instrumentIdType", description="The type of instrument identifier used to uniquely identify the instrument that the quote is for, e.g. 'Figi'.") 
    quote_type:  Optional[StrictStr] = Field(None,alias="quoteType", description="The type of the quote. This allows for quotes other than prices e.g. rates or spreads to be used.") 
    field:  Optional[StrictStr] = Field(None,alias="field", description="The field of the quote e.g. bid, mid, ask etc. This should be consistent across a time series of quotes. The allowed values depend on the provider according to the following rules: Client : *Any value is accepted*; DataScope : 'bid', 'mid', 'ask'; Lusid : *Any value is accepted*; Edi : 'bid', 'mid', 'ask', 'open', 'close', 'last'; TraderMade : 'bid', 'mid', 'ask', 'open', 'close', 'high', 'low'; FactSet : 'bid', 'mid', 'ask', 'open', 'close'; SIX : 'bid', 'mid', 'ask', 'open', 'close', 'last', 'referencePrice', 'highPrice', 'lowPrice', 'maxRedemptionPrice', 'maxSubscriptionPrice', 'openPrice', 'bestBidPrice', 'lastBidPrice', 'bestAskPrice', 'lastAskPrice', 'finalSettlementOptions', 'finalSettlementFutures', 'valuationPriceAmount'; Bloomberg : 'bid', 'mid', 'ask', 'open', 'close', 'last'; Rimes : 'bid', 'mid', 'ask', 'open', 'close', 'last'; ICE : 'ask', 'bid', 'close', 'high', 'low', 'open', 'primaryExchangeTradePrice', 'vwap', 'mid'; LSEG : 'ASK', 'BID', 'MID_PRICE'") 
    __properties = ["provider", "priceSource", "instrumentId", "instrumentIdType", "quoteType", "field"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QuoteAccessMetadataRuleId:
        """Create an instance of QuoteAccessMetadataRuleId from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if provider (nullable) is None
        # and __fields_set__ contains the field
        if self.provider is None and "provider" in self.__fields_set__:
            _dict['provider'] = None

        # set to None if price_source (nullable) is None
        # and __fields_set__ contains the field
        if self.price_source is None and "price_source" in self.__fields_set__:
            _dict['priceSource'] = None

        # set to None if instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_id is None and "instrument_id" in self.__fields_set__:
            _dict['instrumentId'] = None

        # set to None if instrument_id_type (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_id_type is None and "instrument_id_type" in self.__fields_set__:
            _dict['instrumentIdType'] = None

        # set to None if quote_type (nullable) is None
        # and __fields_set__ contains the field
        if self.quote_type is None and "quote_type" in self.__fields_set__:
            _dict['quoteType'] = None

        # set to None if field (nullable) is None
        # and __fields_set__ contains the field
        if self.field is None and "field" in self.__fields_set__:
            _dict['field'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QuoteAccessMetadataRuleId:
        """Create an instance of QuoteAccessMetadataRuleId from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QuoteAccessMetadataRuleId.parse_obj(obj)

        _obj = QuoteAccessMetadataRuleId.parse_obj({
            "provider": obj.get("provider"),
            "price_source": obj.get("priceSource"),
            "instrument_id": obj.get("instrumentId"),
            "instrument_id_type": obj.get("instrumentIdType"),
            "quote_type": obj.get("quoteType"),
            "field": obj.get("field")
        })
        return _obj

QuoteAccessMetadataRuleId.update_forward_refs()
