# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class RecommendedSortBy(BaseModel):
    """
    RecommendedSortBy
    """
    attribute_name:  StrictStr = Field(...,alias="attributeName", description="The property key, identifier type, or field to be sorted by.") 
    sort_order:  Optional[StrictStr] = Field(None,alias="sortOrder", description="The sorting direction. Either ascending (ASC) or descending (DESC).") 
    __properties = ["attributeName", "sortOrder"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RecommendedSortBy:
        """Create an instance of RecommendedSortBy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if sort_order (nullable) is None
        # and __fields_set__ contains the field
        if self.sort_order is None and "sort_order" in self.__fields_set__:
            _dict['sortOrder'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RecommendedSortBy:
        """Create an instance of RecommendedSortBy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RecommendedSortBy.parse_obj(obj)

        _obj = RecommendedSortBy.parse_obj({
            "attribute_name": obj.get("attributeName"),
            "sort_order": obj.get("sortOrder")
        })
        return _obj

RecommendedSortBy.update_forward_refs()
