# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.currency_and_amount import CurrencyAndAmount
from lusid.models.model_property import ModelProperty
from lusid.models.perpetual_property import PerpetualProperty

class ReconciliationBreak(BaseModel):
    """
    A reconciliation break  # noqa: E501
    """
    instrument_scope:  Optional[StrictStr] = Field(None,alias="instrumentScope", description="The scope in which the instrument lies.") 
    instrument_uid:  StrictStr = Field(...,alias="instrumentUid", description="Unique instrument identifier") 
    sub_holding_keys: Dict[str, PerpetualProperty] = Field(description="Any other properties that comprise the Sub-Holding Key", alias="subHoldingKeys")
    left_units: Union[StrictFloat, StrictInt] = Field(description="Units from the left hand side", alias="leftUnits")
    right_units: Union[StrictFloat, StrictInt] = Field(description="Units from the right hand side", alias="rightUnits")
    difference_units: Union[StrictFloat, StrictInt] = Field(description="Difference in units", alias="differenceUnits")
    left_cost: CurrencyAndAmount = Field(alias="leftCost")
    right_cost: CurrencyAndAmount = Field(alias="rightCost")
    difference_cost: CurrencyAndAmount = Field(alias="differenceCost")
    instrument_properties: List[ModelProperty] = Field(description="Additional features relating to the instrument", alias="instrumentProperties")
    __properties = ["instrumentScope", "instrumentUid", "subHoldingKeys", "leftUnits", "rightUnits", "differenceUnits", "leftCost", "rightCost", "differenceCost", "instrumentProperties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReconciliationBreak:
        """Create an instance of ReconciliationBreak from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in sub_holding_keys (dict)
        _field_dict = {}
        if self.sub_holding_keys:
            for _key in self.sub_holding_keys:
                if self.sub_holding_keys[_key]:
                    _field_dict[_key] = self.sub_holding_keys[_key].to_dict()
            _dict['subHoldingKeys'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of left_cost
        if self.left_cost:
            _dict['leftCost'] = self.left_cost.to_dict()
        # override the default output from pydantic by calling `to_dict()` of right_cost
        if self.right_cost:
            _dict['rightCost'] = self.right_cost.to_dict()
        # override the default output from pydantic by calling `to_dict()` of difference_cost
        if self.difference_cost:
            _dict['differenceCost'] = self.difference_cost.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in instrument_properties (list)
        _items = []
        if self.instrument_properties:
            for _item in self.instrument_properties:
                if _item:
                    _items.append(_item.to_dict())
            _dict['instrumentProperties'] = _items
        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReconciliationBreak:
        """Create an instance of ReconciliationBreak from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReconciliationBreak.parse_obj(obj)

        _obj = ReconciliationBreak.parse_obj({
            "instrument_scope": obj.get("instrumentScope"),
            "instrument_uid": obj.get("instrumentUid"),
            "sub_holding_keys": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("subHoldingKeys").items()
            )
            if obj.get("subHoldingKeys") is not None
            else None,
            "left_units": obj.get("leftUnits"),
            "right_units": obj.get("rightUnits"),
            "difference_units": obj.get("differenceUnits"),
            "left_cost": CurrencyAndAmount.from_dict(obj.get("leftCost")) if obj.get("leftCost") is not None else None,
            "right_cost": CurrencyAndAmount.from_dict(obj.get("rightCost")) if obj.get("rightCost") is not None else None,
            "difference_cost": CurrencyAndAmount.from_dict(obj.get("differenceCost")) if obj.get("differenceCost") is not None else None,
            "instrument_properties": [ModelProperty.from_dict(_item) for _item in obj.get("instrumentProperties")] if obj.get("instrumentProperties") is not None else None
        })
        return _obj

ReconciliationBreak.update_forward_refs()
