# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.relational_data_point_field_value_response import RelationalDataPointFieldValueResponse
from lusid.models.relational_data_series_response import RelationalDataSeriesResponse
from lusid.models.resource_id import ResourceId

class RelationalDataPointResponse(BaseModel):
    """
    RelationalDataPointResponse
    """
    relational_dataset_definition_id: ResourceId = Field(alias="relationalDatasetDefinitionId")
    data_series: RelationalDataSeriesResponse = Field(alias="dataSeries")
    effective_at: datetime = Field(description="The effectiveAt or cut-label datetime of the DataPoint.", alias="effectiveAt")
    value_fields: Dict[str, RelationalDataPointFieldValueResponse] = Field(description="The values associated with the DataPoint, structured according to the FieldSchema of the parent RelationalDatasetDefinition.", alias="valueFields")
    meta_data_fields: Dict[str, RelationalDataPointFieldValueResponse] = Field(description="The metadata associated with the DataPoint, structured according to the FieldSchema of the parent RelationalDatasetDefinition.", alias="metaDataFields")
    effective_at_entered:  StrictStr = Field(...,alias="effectiveAtEntered", description="The effectiveAt datetime as entered when the DataPoint was created.") 
    __properties = ["relationalDatasetDefinitionId", "dataSeries", "effectiveAt", "valueFields", "metaDataFields", "effectiveAtEntered"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RelationalDataPointResponse:
        """Create an instance of RelationalDataPointResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of relational_dataset_definition_id
        if self.relational_dataset_definition_id:
            _dict['relationalDatasetDefinitionId'] = self.relational_dataset_definition_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_series
        if self.data_series:
            _dict['dataSeries'] = self.data_series.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in value_fields (dict)
        _field_dict = {}
        if self.value_fields:
            for _key in self.value_fields:
                if self.value_fields[_key]:
                    _field_dict[_key] = self.value_fields[_key].to_dict()
            _dict['valueFields'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in meta_data_fields (dict)
        _field_dict = {}
        if self.meta_data_fields:
            for _key in self.meta_data_fields:
                if self.meta_data_fields[_key]:
                    _field_dict[_key] = self.meta_data_fields[_key].to_dict()
            _dict['metaDataFields'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RelationalDataPointResponse:
        """Create an instance of RelationalDataPointResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RelationalDataPointResponse.parse_obj(obj)

        _obj = RelationalDataPointResponse.parse_obj({
            "relational_dataset_definition_id": ResourceId.from_dict(obj.get("relationalDatasetDefinitionId")) if obj.get("relationalDatasetDefinitionId") is not None else None,
            "data_series": RelationalDataSeriesResponse.from_dict(obj.get("dataSeries")) if obj.get("dataSeries") is not None else None,
            "effective_at": obj.get("effectiveAt"),
            "value_fields": dict(
                (_k, RelationalDataPointFieldValueResponse.from_dict(_v))
                for _k, _v in obj.get("valueFields").items()
            )
            if obj.get("valueFields") is not None
            else None,
            "meta_data_fields": dict(
                (_k, RelationalDataPointFieldValueResponse.from_dict(_v))
                for _k, _v in obj.get("metaDataFields").items()
            )
            if obj.get("metaDataFields") is not None
            else None,
            "effective_at_entered": obj.get("effectiveAtEntered")
        })
        return _obj

RelationalDataPointResponse.update_forward_refs()
