# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.applicable_entity import ApplicableEntity
from lusid.models.relational_data_point_field_value_response import RelationalDataPointFieldValueResponse

class RelationalDataSeriesResponse(BaseModel):
    """
    RelationalDataSeriesResponse
    """
    series_scope:  StrictStr = Field(...,alias="seriesScope", description="The scope of the DataSeries.") 
    applicable_entity: ApplicableEntity = Field(alias="applicableEntity")
    series_identifiers: Dict[str, RelationalDataPointFieldValueResponse] = Field(description="The identifiers that uniquely define this DataSeries, structured according to the FieldSchema of the parent RelationalDatasetDefinition.", alias="seriesIdentifiers")
    __properties = ["seriesScope", "applicableEntity", "seriesIdentifiers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RelationalDataSeriesResponse:
        """Create an instance of RelationalDataSeriesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of applicable_entity
        if self.applicable_entity:
            _dict['applicableEntity'] = self.applicable_entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in series_identifiers (dict)
        _field_dict = {}
        if self.series_identifiers:
            for _key in self.series_identifiers:
                if self.series_identifiers[_key]:
                    _field_dict[_key] = self.series_identifiers[_key].to_dict()
            _dict['seriesIdentifiers'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RelationalDataSeriesResponse:
        """Create an instance of RelationalDataSeriesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RelationalDataSeriesResponse.parse_obj(obj)

        _obj = RelationalDataSeriesResponse.parse_obj({
            "series_scope": obj.get("seriesScope"),
            "applicable_entity": ApplicableEntity.from_dict(obj.get("applicableEntity")) if obj.get("applicableEntity") is not None else None,
            "series_identifiers": dict(
                (_k, RelationalDataPointFieldValueResponse.from_dict(_v))
                for _k, _v in obj.get("seriesIdentifiers").items()
            )
            if obj.get("seriesIdentifiers") is not None
            else None
        })
        return _obj

RelationalDataSeriesResponse.update_forward_refs()
