# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.relational_dataset_field_definition import RelationalDatasetFieldDefinition
from lusid.models.update_series_identifier_field import UpdateSeriesIdentifierField

class RelationalDatasetFieldsToUpdate(BaseModel):
    """
    RelationalDatasetFieldsToUpdate
    """
    series_identifiers: Optional[List[UpdateSeriesIdentifierField]] = Field(default=None, description="The schema defining the structure and data types of the relational dataset.", alias="seriesIdentifiers")
    value_and_metadata_fields: Optional[List[RelationalDatasetFieldDefinition]] = Field(default=None, description="The schema defining the structure and data types of the relational dataset.", alias="valueAndMetadataFields")
    __properties = ["seriesIdentifiers", "valueAndMetadataFields"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RelationalDatasetFieldsToUpdate:
        """Create an instance of RelationalDatasetFieldsToUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in series_identifiers (list)
        _items = []
        if self.series_identifiers:
            for _item in self.series_identifiers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['seriesIdentifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in value_and_metadata_fields (list)
        _items = []
        if self.value_and_metadata_fields:
            for _item in self.value_and_metadata_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['valueAndMetadataFields'] = _items
        # set to None if series_identifiers (nullable) is None
        # and __fields_set__ contains the field
        if self.series_identifiers is None and "series_identifiers" in self.__fields_set__:
            _dict['seriesIdentifiers'] = None

        # set to None if value_and_metadata_fields (nullable) is None
        # and __fields_set__ contains the field
        if self.value_and_metadata_fields is None and "value_and_metadata_fields" in self.__fields_set__:
            _dict['valueAndMetadataFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RelationalDatasetFieldsToUpdate:
        """Create an instance of RelationalDatasetFieldsToUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RelationalDatasetFieldsToUpdate.parse_obj(obj)

        _obj = RelationalDatasetFieldsToUpdate.parse_obj({
            "series_identifiers": [UpdateSeriesIdentifierField.from_dict(_item) for _item in obj.get("seriesIdentifiers")] if obj.get("seriesIdentifiers") is not None else None,
            "value_and_metadata_fields": [RelationalDatasetFieldDefinition.from_dict(_item) for _item in obj.get("valueAndMetadataFields")] if obj.get("valueAndMetadataFields") is not None else None
        })
        return _obj

RelationalDatasetFieldsToUpdate.update_forward_refs()
