# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class RequestedChanges(BaseModel):
    """
    RequestedChanges
    """
    attribute_count: Optional[StrictInt] = Field(default=None, description="Number of attributes staged change applies to", alias="attributeCount")
    attribute_names: Optional[List[StrictStr]] = Field(default=None, description="Names of the attributes the staged change applies to.", alias="attributeNames")
    __properties = ["attributeCount", "attributeNames"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RequestedChanges:
        """Create an instance of RequestedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if attribute_names (nullable) is None
        # and __fields_set__ contains the field
        if self.attribute_names is None and "attribute_names" in self.__fields_set__:
            _dict['attributeNames'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RequestedChanges:
        """Create an instance of RequestedChanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RequestedChanges.parse_obj(obj)

        _obj = RequestedChanges.parse_obj({
            "attribute_count": obj.get("attributeCount"),
            "attribute_names": obj.get("attributeNames")
        })
        return _obj

RequestedChanges.update_forward_refs()
