# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.address_definition import AddressDefinition
from lusid.models.field_schema import FieldSchema

class ResultDataSchema(BaseModel):
    """
    The shape and type of the returned data. The AddressSchema gives information about the requested keys,  including the return type, links to further documentation, lifecycle status and removal date if they are  deprecated.                Note: the NodeValueSchema and PropertySchema fields have been deprecated. Please use the AddressSchema instead.  # noqa: E501
    """
    node_value_schema: Optional[Dict[str, FieldSchema]] = Field(default=None, description="This has been deprecated. Please use AddressSchema instead.", alias="nodeValueSchema")
    property_schema: Optional[Dict[str, FieldSchema]] = Field(default=None, description="This has been deprecated. Please use AddressSchema instead.", alias="propertySchema")
    address_schema: Optional[Dict[str, AddressDefinition]] = Field(default=None, alias="addressSchema")
    __properties = ["nodeValueSchema", "propertySchema", "addressSchema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResultDataSchema:
        """Create an instance of ResultDataSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in node_value_schema (dict)
        _field_dict = {}
        if self.node_value_schema:
            for _key in self.node_value_schema:
                if self.node_value_schema[_key]:
                    _field_dict[_key] = self.node_value_schema[_key].to_dict()
            _dict['nodeValueSchema'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in property_schema (dict)
        _field_dict = {}
        if self.property_schema:
            for _key in self.property_schema:
                if self.property_schema[_key]:
                    _field_dict[_key] = self.property_schema[_key].to_dict()
            _dict['propertySchema'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in address_schema (dict)
        _field_dict = {}
        if self.address_schema:
            for _key in self.address_schema:
                if self.address_schema[_key]:
                    _field_dict[_key] = self.address_schema[_key].to_dict()
            _dict['addressSchema'] = _field_dict
        # set to None if node_value_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.node_value_schema is None and "node_value_schema" in self.__fields_set__:
            _dict['nodeValueSchema'] = None

        # set to None if property_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.property_schema is None and "property_schema" in self.__fields_set__:
            _dict['propertySchema'] = None

        # set to None if address_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.address_schema is None and "address_schema" in self.__fields_set__:
            _dict['addressSchema'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResultDataSchema:
        """Create an instance of ResultDataSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResultDataSchema.parse_obj(obj)

        _obj = ResultDataSchema.parse_obj({
            "node_value_schema": dict(
                (_k, FieldSchema.from_dict(_v))
                for _k, _v in obj.get("nodeValueSchema").items()
            )
            if obj.get("nodeValueSchema") is not None
            else None,
            "property_schema": dict(
                (_k, FieldSchema.from_dict(_v))
                for _k, _v in obj.get("propertySchema").items()
            )
            if obj.get("propertySchema") is not None
            else None,
            "address_schema": dict(
                (_k, AddressDefinition.from_dict(_v))
                for _k, _v in obj.get("addressSchema").items()
            )
            if obj.get("addressSchema") is not None
            else None
        })
        return _obj

ResultDataSchema.update_forward_refs()
