# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.lusid_entity_dataset import LusidEntityDataset

class RunCheckRequest(BaseModel):
    """
    RunCheckRequest
    """
    lusid_entity_dataset: Optional[LusidEntityDataset] = Field(default=None, alias="lusidEntityDataset")
    limit_individual_breaches_per_rule: Optional[StrictInt] = Field(default=None, description="The maximum number of individual breaches to return per rule. Defaults to 100 if not specified.", alias="limitIndividualBreachesPerRule")
    __properties = ["lusidEntityDataset", "limitIndividualBreachesPerRule"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RunCheckRequest:
        """Create an instance of RunCheckRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of lusid_entity_dataset
        if self.lusid_entity_dataset:
            _dict['lusidEntityDataset'] = self.lusid_entity_dataset.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RunCheckRequest:
        """Create an instance of RunCheckRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RunCheckRequest.parse_obj(obj)

        _obj = RunCheckRequest.parse_obj({
            "lusid_entity_dataset": LusidEntityDataset.from_dict(obj.get("lusidEntityDataset")) if obj.get("lusidEntityDataset") is not None else None,
            "limit_individual_breaches_per_rule": obj.get("limitIndividualBreachesPerRule")
        })
        return _obj

RunCheckRequest.update_forward_refs()
