# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.data_quality_check_result import DataQualityCheckResult

class RunCheckResponse(BaseModel):
    """
    Response containing the results of running data quality checks  # noqa: E501
    """
    data_quality_check_results: Optional[List[DataQualityCheckResult]] = Field(default=None, description="Collection of data quality check results", alias="dataQualityCheckResults")
    __properties = ["dataQualityCheckResults"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RunCheckResponse:
        """Create an instance of RunCheckResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in data_quality_check_results (list)
        _items = []
        if self.data_quality_check_results:
            for _item in self.data_quality_check_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dataQualityCheckResults'] = _items
        # set to None if data_quality_check_results (nullable) is None
        # and __fields_set__ contains the field
        if self.data_quality_check_results is None and "data_quality_check_results" in self.__fields_set__:
            _dict['dataQualityCheckResults'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RunCheckResponse:
        """Create an instance of RunCheckResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RunCheckResponse.parse_obj(obj)

        _obj = RunCheckResponse.parse_obj({
            "data_quality_check_results": [DataQualityCheckResult.from_dict(_item) for _item in obj.get("dataQualityCheckResults")] if obj.get("dataQualityCheckResults") is not None else None
        })
        return _obj

RunCheckResponse.update_forward_refs()
