# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class SettlementConfigurationCategory(BaseModel):
    """
    SettlementConfigurationCategory
    """
    method:  Optional[StrictStr] = Field(None,alias="method", description="The method of settlement for the movements of the relevant type(s). Allowed values: 'Automatic' and 'Instructed'. A value of 'Instructed' means that such movements can only be settled with a SettlementInstruction. A value of 'Automatic' means that such movements will settle automatically but a SettlementInstruction will still override automatic settlement.") 
    calculate_instruction_to_portfolio_rate: Optional[StrictBool] = Field(default=None, description="An optional flag that allows for the calculation of the instruction to portfolio rate for instructions with settlement category CashSettlement or DeferredCashReceipt, if it is not provided on the settlement instruction. Defaults to false if not specified.", alias="calculateInstructionToPortfolioRate")
    calculate_in_lieu_settlement_amount: Optional[StrictBool] = Field(default=None, description="An optional flag that allows for the calculation of the in lieu amount for instructions with settlement category CashSettlement or DeferredCashReceipt, if it is not provided on the settlement instruction. Defaults to false if not specified.", alias="calculateInLieuSettlementAmount")
    __properties = ["method", "calculateInstructionToPortfolioRate", "calculateInLieuSettlementAmount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SettlementConfigurationCategory:
        """Create an instance of SettlementConfigurationCategory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if method (nullable) is None
        # and __fields_set__ contains the field
        if self.method is None and "method" in self.__fields_set__:
            _dict['method'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SettlementConfigurationCategory:
        """Create an instance of SettlementConfigurationCategory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SettlementConfigurationCategory.parse_obj(obj)

        _obj = SettlementConfigurationCategory.parse_obj({
            "method": obj.get("method"),
            "calculate_instruction_to_portfolio_rate": obj.get("calculateInstructionToPortfolioRate"),
            "calculate_in_lieu_settlement_amount": obj.get("calculateInLieuSettlementAmount")
        })
        return _obj

SettlementConfigurationCategory.update_forward_refs()
