# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.output_transaction import OutputTransaction
from lusid.models.transaction_settlement_instruction import TransactionSettlementInstruction

class SettlementInstructionWithTransaction(BaseModel):
    """
    A Settlement Instruction with its Matched Transaction (if any)  # noqa: E501
    """
    settlement_instruction: Optional[TransactionSettlementInstruction] = Field(default=None, alias="settlementInstruction")
    matched_transaction: Optional[OutputTransaction] = Field(default=None, alias="matchedTransaction")
    __properties = ["settlementInstruction", "matchedTransaction"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SettlementInstructionWithTransaction:
        """Create an instance of SettlementInstructionWithTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of settlement_instruction
        if self.settlement_instruction:
            _dict['settlementInstruction'] = self.settlement_instruction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of matched_transaction
        if self.matched_transaction:
            _dict['matchedTransaction'] = self.matched_transaction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SettlementInstructionWithTransaction:
        """Create an instance of SettlementInstructionWithTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SettlementInstructionWithTransaction.parse_obj(obj)

        _obj = SettlementInstructionWithTransaction.parse_obj({
            "settlement_instruction": TransactionSettlementInstruction.from_dict(obj.get("settlementInstruction")) if obj.get("settlementInstruction") is not None else None,
            "matched_transaction": OutputTransaction.from_dict(obj.get("matchedTransaction")) if obj.get("matchedTransaction") is not None else None
        })
        return _obj

SettlementInstructionWithTransaction.update_forward_refs()
