# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class SettlementProblem(BaseModel):
    """
    SettlementProblem
    """
    settlement_instruction_id:  StrictStr = Field(...,alias="settlementInstructionId", description="The id of the problematic settlement instruction. Combined with the portfolio id this uniquely identifies a settlement instruction") 
    category:  StrictStr = Field(...,alias="category", description="The category this instruction belongs to") 
    status:  StrictStr = Field(...,alias="status", description="The status of the settlement instruction. Possible values are 'Invalid' or 'Rejected'.") 
    __properties = ["settlementInstructionId", "category", "status"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SettlementProblem:
        """Create an instance of SettlementProblem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SettlementProblem:
        """Create an instance of SettlementProblem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SettlementProblem.parse_obj(obj)

        _obj = SettlementProblem.parse_obj({
            "settlement_instruction_id": obj.get("settlementInstructionId"),
            "category": obj.get("category"),
            "status": obj.get("status")
        })
        return _obj

SettlementProblem.update_forward_refs()
