# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.currency_and_amount import CurrencyAndAmount

class TargetTaxLotRequest(BaseModel):
    """
    TargetTaxLotRequest
    """
    units: Union[StrictFloat, StrictInt] = Field(description="The number of units of the instrument in this tax-lot.")
    cost: Optional[CurrencyAndAmount] = None
    portfolio_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total cost of the tax-lot in the transaction portfolio's base currency.", alias="portfolioCost")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The purchase price of each unit of the instrument held in this tax-lot. This forms part of the unique key required for multiple tax-lots.")
    purchase_date: Optional[datetime] = Field(default=None, description="The purchase date of this tax-lot. This forms part of the unique key required for multiple tax-lots.", alias="purchaseDate")
    settlement_date: Optional[datetime] = Field(default=None, description="The settlement date of the tax-lot's opening transaction.", alias="settlementDate")
    notional_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The notional cost of the tax-lot's opening transaction.", alias="notionalCost")
    variation_margin: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The variation margin of the tax-lot's opening transaction.", alias="variationMargin")
    variation_margin_portfolio_ccy: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The variation margin in portfolio currency of the tax-lot's opening transaction.", alias="variationMarginPortfolioCcy")
    __properties = ["units", "cost", "portfolioCost", "price", "purchaseDate", "settlementDate", "notionalCost", "variationMargin", "variationMarginPortfolioCcy"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TargetTaxLotRequest:
        """Create an instance of TargetTaxLotRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of cost
        if self.cost:
            _dict['cost'] = self.cost.to_dict()
        # set to None if portfolio_cost (nullable) is None
        # and __fields_set__ contains the field
        if self.portfolio_cost is None and "portfolio_cost" in self.__fields_set__:
            _dict['portfolioCost'] = None

        # set to None if price (nullable) is None
        # and __fields_set__ contains the field
        if self.price is None and "price" in self.__fields_set__:
            _dict['price'] = None

        # set to None if purchase_date (nullable) is None
        # and __fields_set__ contains the field
        if self.purchase_date is None and "purchase_date" in self.__fields_set__:
            _dict['purchaseDate'] = None

        # set to None if settlement_date (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_date is None and "settlement_date" in self.__fields_set__:
            _dict['settlementDate'] = None

        # set to None if notional_cost (nullable) is None
        # and __fields_set__ contains the field
        if self.notional_cost is None and "notional_cost" in self.__fields_set__:
            _dict['notionalCost'] = None

        # set to None if variation_margin (nullable) is None
        # and __fields_set__ contains the field
        if self.variation_margin is None and "variation_margin" in self.__fields_set__:
            _dict['variationMargin'] = None

        # set to None if variation_margin_portfolio_ccy (nullable) is None
        # and __fields_set__ contains the field
        if self.variation_margin_portfolio_ccy is None and "variation_margin_portfolio_ccy" in self.__fields_set__:
            _dict['variationMarginPortfolioCcy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TargetTaxLotRequest:
        """Create an instance of TargetTaxLotRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TargetTaxLotRequest.parse_obj(obj)

        _obj = TargetTaxLotRequest.parse_obj({
            "units": obj.get("units"),
            "cost": CurrencyAndAmount.from_dict(obj.get("cost")) if obj.get("cost") is not None else None,
            "portfolio_cost": obj.get("portfolioCost"),
            "price": obj.get("price"),
            "purchase_date": obj.get("purchaseDate"),
            "settlement_date": obj.get("settlementDate"),
            "notional_cost": obj.get("notionalCost"),
            "variation_margin": obj.get("variationMargin"),
            "variation_margin_portfolio_ccy": obj.get("variationMarginPortfolioCcy")
        })
        return _obj

TargetTaxLotRequest.update_forward_refs()
