# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.match_criterion import MatchCriterion

class TaxRule(BaseModel):
    """
    TaxRule
    """
    name:  StrictStr = Field(...,alias="name", description="A user-friendly name") 
    description:  StrictStr = Field(...,alias="description", description="A description for this rule") 
    rate: Union[StrictFloat, StrictInt] = Field(description="The rate to be applied if all criteria are met")
    match_criteria: List[MatchCriterion] = Field(description="A set of criteria to be met for this rule to be applied", alias="matchCriteria")
    __properties = ["name", "description", "rate", "matchCriteria"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TaxRule:
        """Create an instance of TaxRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in match_criteria (list)
        _items = []
        if self.match_criteria:
            for _item in self.match_criteria:
                if _item:
                    _items.append(_item.to_dict())
            _dict['matchCriteria'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TaxRule:
        """Create an instance of TaxRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TaxRule.parse_obj(obj)

        _obj = TaxRule.parse_obj({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "rate": obj.get("rate"),
            "match_criteria": [MatchCriterion.from_dict(_item) for _item in obj.get("matchCriteria")] if obj.get("matchCriteria") is not None else None
        })
        return _obj

TaxRule.update_forward_refs()
