# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.transaction_settlement_instruction import TransactionSettlementInstruction
from lusid.models.transaction_settlement_movement import TransactionSettlementMovement

class TransactionSettlementBucket(BaseModel):
    """
    TransactionSettlementBucket
    """
    settlement_category:  StrictStr = Field(...,alias="settlementCategory", description="A category representing the set of movement types that this instruction applies to.") 
    lusid_instrument_id:  StrictStr = Field(...,alias="lusidInstrumentId", description="The LusidInstrumentId of the instrument being settled.") 
    instrument_scope:  StrictStr = Field(...,alias="instrumentScope", description="The Scope of the instrument being settled.") 
    contractual_settlement_date: Optional[datetime] = Field(default=None, description="The contractual settlement date. Used to match the instruction to the correct settlement bucket.", alias="contractualSettlementDate")
    contracted_units: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The contracted units.", alias="contractedUnits")
    settled_units: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The settled units.", alias="settledUnits")
    unsettled_units: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The unsettled units.", alias="unsettledUnits")
    overdue_units: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The overdue units.", alias="overdueUnits")
    configured_settlement:  Optional[StrictStr] = Field(None,alias="configuredSettlement", description="The method of settlement for the settlement bucket, as defined in the portfolio's SettlementConfiguration") 
    status:  StrictStr = Field(...,alias="status", description="The Status of the settlement bucket - 'Settled', 'Part Settled' or 'Unsettled'.") 
    settlement_instructions: Optional[List[TransactionSettlementInstruction]] = Field(default=None, description="The settlement instructions received for this settlement bucket.", alias="settlementInstructions")
    movements: Optional[List[TransactionSettlementMovement]] = Field(default=None, description="The movements for the settlement bucket.")
    __properties = ["settlementCategory", "lusidInstrumentId", "instrumentScope", "contractualSettlementDate", "contractedUnits", "settledUnits", "unsettledUnits", "overdueUnits", "configuredSettlement", "status", "settlementInstructions", "movements"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionSettlementBucket:
        """Create an instance of TransactionSettlementBucket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in settlement_instructions (list)
        _items = []
        if self.settlement_instructions:
            for _item in self.settlement_instructions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['settlementInstructions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in movements (list)
        _items = []
        if self.movements:
            for _item in self.movements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['movements'] = _items
        # set to None if contractual_settlement_date (nullable) is None
        # and __fields_set__ contains the field
        if self.contractual_settlement_date is None and "contractual_settlement_date" in self.__fields_set__:
            _dict['contractualSettlementDate'] = None

        # set to None if configured_settlement (nullable) is None
        # and __fields_set__ contains the field
        if self.configured_settlement is None and "configured_settlement" in self.__fields_set__:
            _dict['configuredSettlement'] = None

        # set to None if settlement_instructions (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_instructions is None and "settlement_instructions" in self.__fields_set__:
            _dict['settlementInstructions'] = None

        # set to None if movements (nullable) is None
        # and __fields_set__ contains the field
        if self.movements is None and "movements" in self.__fields_set__:
            _dict['movements'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionSettlementBucket:
        """Create an instance of TransactionSettlementBucket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionSettlementBucket.parse_obj(obj)

        _obj = TransactionSettlementBucket.parse_obj({
            "settlement_category": obj.get("settlementCategory"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "contractual_settlement_date": obj.get("contractualSettlementDate"),
            "contracted_units": obj.get("contractedUnits"),
            "settled_units": obj.get("settledUnits"),
            "unsettled_units": obj.get("unsettledUnits"),
            "overdue_units": obj.get("overdueUnits"),
            "configured_settlement": obj.get("configuredSettlement"),
            "status": obj.get("status"),
            "settlement_instructions": [TransactionSettlementInstruction.from_dict(_item) for _item in obj.get("settlementInstructions")] if obj.get("settlementInstructions") is not None else None,
            "movements": [TransactionSettlementMovement.from_dict(_item) for _item in obj.get("movements")] if obj.get("movements") is not None else None
        })
        return _obj

TransactionSettlementBucket.update_forward_refs()
