# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link
from lusid.models.transaction_settlement_bucket import TransactionSettlementBucket
from lusid.models.transaction_settlement_instruction import TransactionSettlementInstruction

class TransactionSettlementStatus(BaseModel):
    """
    TransactionSettlementStatus
    """
    transaction_id:  StrictStr = Field(...,alias="transactionId", description="The unique identifier for the transaction.") 
    settlement_buckets: Optional[List[TransactionSettlementBucket]] = Field(default=None, description="The transaction's external movements (ie: with SettlementMode=External) are grouped into buckets with each bucket uniquely defined by the combination of SettlementCategory, LusidInstrumentId, InstrumentScope and ContractualSettlementDate.", alias="settlementBuckets")
    invalid_instructions: Optional[List[TransactionSettlementInstruction]] = Field(default=None, description="Invalid settlement instructions where the referenced transaction exists but the settlement bucket implied by the settlement instruction does not exist.", alias="invalidInstructions")
    links: Optional[List[Link]] = None
    __properties = ["transactionId", "settlementBuckets", "invalidInstructions", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionSettlementStatus:
        """Create an instance of TransactionSettlementStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in settlement_buckets (list)
        _items = []
        if self.settlement_buckets:
            for _item in self.settlement_buckets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['settlementBuckets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invalid_instructions (list)
        _items = []
        if self.invalid_instructions:
            for _item in self.invalid_instructions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['invalidInstructions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if settlement_buckets (nullable) is None
        # and __fields_set__ contains the field
        if self.settlement_buckets is None and "settlement_buckets" in self.__fields_set__:
            _dict['settlementBuckets'] = None

        # set to None if invalid_instructions (nullable) is None
        # and __fields_set__ contains the field
        if self.invalid_instructions is None and "invalid_instructions" in self.__fields_set__:
            _dict['invalidInstructions'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionSettlementStatus:
        """Create an instance of TransactionSettlementStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionSettlementStatus.parse_obj(obj)

        _obj = TransactionSettlementStatus.parse_obj({
            "transaction_id": obj.get("transactionId"),
            "settlement_buckets": [TransactionSettlementBucket.from_dict(_item) for _item in obj.get("settlementBuckets")] if obj.get("settlementBuckets") is not None else None,
            "invalid_instructions": [TransactionSettlementInstruction.from_dict(_item) for _item in obj.get("invalidInstructions")] if obj.get("invalidInstructions") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

TransactionSettlementStatus.update_forward_refs()
