# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.category_settlement_status import CategorySettlementStatus

class TransactionSettlementSummary(BaseModel):
    """
    TransactionSettlementSummary
    """
    overall_status: CategorySettlementStatus = Field(alias="overallStatus")
    stock_status: CategorySettlementStatus = Field(alias="stockStatus")
    cash_status: CategorySettlementStatus = Field(alias="cashStatus")
    deferred_cash_receipt_status: CategorySettlementStatus = Field(alias="deferredCashReceiptStatus")
    __properties = ["overallStatus", "stockStatus", "cashStatus", "deferredCashReceiptStatus"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionSettlementSummary:
        """Create an instance of TransactionSettlementSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of overall_status
        if self.overall_status:
            _dict['overallStatus'] = self.overall_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stock_status
        if self.stock_status:
            _dict['stockStatus'] = self.stock_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cash_status
        if self.cash_status:
            _dict['cashStatus'] = self.cash_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of deferred_cash_receipt_status
        if self.deferred_cash_receipt_status:
            _dict['deferredCashReceiptStatus'] = self.deferred_cash_receipt_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionSettlementSummary:
        """Create an instance of TransactionSettlementSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionSettlementSummary.parse_obj(obj)

        _obj = TransactionSettlementSummary.parse_obj({
            "overall_status": CategorySettlementStatus.from_dict(obj.get("overallStatus")) if obj.get("overallStatus") is not None else None,
            "stock_status": CategorySettlementStatus.from_dict(obj.get("stockStatus")) if obj.get("stockStatus") is not None else None,
            "cash_status": CategorySettlementStatus.from_dict(obj.get("cashStatus")) if obj.get("cashStatus") is not None else None,
            "deferred_cash_receipt_status": CategorySettlementStatus.from_dict(obj.get("deferredCashReceiptStatus")) if obj.get("deferredCashReceiptStatus") is not None else None
        })
        return _obj

TransactionSettlementSummary.update_forward_refs()
