# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.component_transaction import ComponentTransaction
from lusid.models.link import Link

class TransactionTemplate(BaseModel):
    """
    TransactionTemplate
    """
    instrument_type:  StrictStr = Field(...,alias="instrumentType", description="A value that represents the instrument type.") 
    instrument_event_type:  StrictStr = Field(...,alias="instrumentEventType", description="A value that represents the instrument event type.") 
    description:  StrictStr = Field(...,alias="description", description="The description of the transaction template.") 
    scope:  StrictStr = Field(...,alias="scope", description="The scope in which the transaction template resides.") 
    component_transactions: List[ComponentTransaction] = Field(description="A set of component transactions that relate to the template to be created.", alias="componentTransactions")
    links: Optional[List[Link]] = None
    __properties = ["instrumentType", "instrumentEventType", "description", "scope", "componentTransactions", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionTemplate:
        """Create an instance of TransactionTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in component_transactions (list)
        _items = []
        if self.component_transactions:
            for _item in self.component_transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['componentTransactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionTemplate:
        """Create an instance of TransactionTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionTemplate.parse_obj(obj)

        _obj = TransactionTemplate.parse_obj({
            "instrument_type": obj.get("instrumentType"),
            "instrument_event_type": obj.get("instrumentEventType"),
            "description": obj.get("description"),
            "scope": obj.get("scope"),
            "component_transactions": [ComponentTransaction.from_dict(_item) for _item in obj.get("componentTransactions")] if obj.get("componentTransactions") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

TransactionTemplate.update_forward_refs()
