# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class TransactionTypeDetails(BaseModel):
    """
    TransactionTypeDetails
    """
    scope:  StrictStr = Field(...,alias="scope", description="The scope in which the TransactionType was resolved. If the portfolio has a TransactionTypeScope, this will have been used. Otherwise the default scope will have been used.") 
    source:  StrictStr = Field(...,alias="source", description="The source in which the TransactionType was resolved.") 
    type:  StrictStr = Field(...,alias="type", description="The resolved TransactionType. More information on TransactionType resolution can be found at https://support.lusid.com/docs/how-does-lusid-resolve-transactions-to-transaction-types") 
    __properties = ["scope", "source", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionTypeDetails:
        """Create an instance of TransactionTypeDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionTypeDetails:
        """Create an instance of TransactionTypeDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransactionTypeDetails.parse_obj(obj)

        _obj = TransactionTypeDetails.parse_obj({
            "scope": obj.get("scope"),
            "source": obj.get("source"),
            "type": obj.get("type")
        })
        return _obj

TransactionTypeDetails.update_forward_refs()
