# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link

class TransferAgencyDates(BaseModel):
    """
    TransferAgencyDates
    """
    price_date: Optional[datetime] = Field(default=None, description="The date at which the fund is priced, for the order received on ReceivedDate. Can be passed into the request instead of the ReceivedDate to calculate the TransactionDate and ExpectedPaymentDate. If both the received date and price date are given, a failure is returned.", alias="priceDate")
    transaction_date: Optional[datetime] = Field(default=None, description="The date at which the transaction into or out of the fund is made.", alias="transactionDate")
    expected_payment_date: Optional[datetime] = Field(default=None, description="The date by which the cash is expected to be paid to or from the fund.", alias="expectedPaymentDate")
    links: Optional[List[Link]] = None
    __properties = ["priceDate", "transactionDate", "expectedPaymentDate", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransferAgencyDates:
        """Create an instance of TransferAgencyDates from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferAgencyDates:
        """Create an instance of TransferAgencyDates from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransferAgencyDates.parse_obj(obj)

        _obj = TransferAgencyDates.parse_obj({
            "price_date": obj.get("priceDate"),
            "transaction_date": obj.get("transactionDate"),
            "expected_payment_date": obj.get("expectedPaymentDate"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

TransferAgencyDates.update_forward_refs()
