# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class UnitisationData(BaseModel):
    """
    UnitisationData
    """
    shares_in_issue: Union[StrictFloat, StrictInt] = Field(description="The number of shares in issue at a valuation point.", alias="sharesInIssue")
    unit_price: Union[StrictFloat, StrictInt] = Field(description="The price of one unit of the share class at a valuation point.", alias="unitPrice")
    net_dealing_units: Union[StrictFloat, StrictInt] = Field(description="The net dealing in units for the share class at a valuation point. This could be the sum of negative redemptions (in units) and positive subscriptions (in units).", alias="netDealingUnits")
    __properties = ["sharesInIssue", "unitPrice", "netDealingUnits"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UnitisationData:
        """Create an instance of UnitisationData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UnitisationData:
        """Create an instance of UnitisationData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UnitisationData.parse_obj(obj)

        _obj = UnitisationData.parse_obj({
            "shares_in_issue": obj.get("sharesInIssue"),
            "unit_price": obj.get("unitPrice"),
            "net_dealing_units": obj.get("netDealingUnits")
        })
        return _obj

UnitisationData.update_forward_refs()
