# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.check_definition_dataset_schema import CheckDefinitionDatasetSchema
from lusid.models.check_definition_rule_set import CheckDefinitionRuleSet
from lusid.models.model_property import ModelProperty

class UpdateCheckDefinitionRequest(BaseModel):
    """
    UpdateCheckDefinitionRequest
    """
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the Check Definition.") 
    description:  StrictStr = Field(...,alias="description", description="A description for the Check Definition.") 
    dataset_schema: Optional[CheckDefinitionDatasetSchema] = Field(default=None, alias="datasetSchema")
    rule_sets: List[CheckDefinitionRuleSet] = Field(description="A collection of rule sets for the Check Definition.", alias="ruleSets")
    properties: Optional[Dict[str, ModelProperty]] = Field(default=None, description="A set of properties for the Check Definition.")
    __properties = ["displayName", "description", "datasetSchema", "ruleSets", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateCheckDefinitionRequest:
        """Create an instance of UpdateCheckDefinitionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of dataset_schema
        if self.dataset_schema:
            _dict['datasetSchema'] = self.dataset_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rule_sets (list)
        _items = []
        if self.rule_sets:
            for _item in self.rule_sets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ruleSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateCheckDefinitionRequest:
        """Create an instance of UpdateCheckDefinitionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateCheckDefinitionRequest.parse_obj(obj)

        _obj = UpdateCheckDefinitionRequest.parse_obj({
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "dataset_schema": CheckDefinitionDatasetSchema.from_dict(obj.get("datasetSchema")) if obj.get("datasetSchema") is not None else None,
            "rule_sets": [CheckDefinitionRuleSet.from_dict(_item) for _item in obj.get("ruleSets")] if obj.get("ruleSets") is not None else None,
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None
        })
        return _obj

UpdateCheckDefinitionRequest.update_forward_refs()
