# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.break_code_source import BreakCodeSource
from lusid.models.group_reconciliation_definition_comparison_ruleset_ids import GroupReconciliationDefinitionComparisonRulesetIds
from lusid.models.group_reconciliation_definition_currencies import GroupReconciliationDefinitionCurrencies
from lusid.models.group_reconciliation_definition_portfolio_entity_ids import GroupReconciliationDefinitionPortfolioEntityIds
from lusid.models.group_reconciliation_definition_recipe_ids import GroupReconciliationDefinitionRecipeIds
from lusid.models.primary_schedule import PrimarySchedule
from lusid.models.transaction_date_windows import TransactionDateWindows

class UpdateGroupReconciliationDefinitionRequest(BaseModel):
    """
    UpdateGroupReconciliationDefinitionRequest
    """
    display_name:  StrictStr = Field(...,alias="displayName", description="The name of the Group Reconciliation Definition") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="The description of the Group Reconciliation Definition") 
    portfolio_entity_ids: GroupReconciliationDefinitionPortfolioEntityIds = Field(alias="portfolioEntityIds")
    recipe_ids: Optional[GroupReconciliationDefinitionRecipeIds] = Field(default=None, alias="recipeIds")
    currencies: Optional[GroupReconciliationDefinitionCurrencies] = None
    transaction_date_windows: Optional[TransactionDateWindows] = Field(default=None, alias="transactionDateWindows")
    comparison_ruleset_ids: Optional[GroupReconciliationDefinitionComparisonRulesetIds] = Field(default=None, alias="comparisonRulesetIds")
    break_code_source: Optional[BreakCodeSource] = Field(default=None, alias="breakCodeSource")
    primary_schedule: Optional[PrimarySchedule] = Field(default=None, alias="primarySchedule")
    __properties = ["displayName", "description", "portfolioEntityIds", "recipeIds", "currencies", "transactionDateWindows", "comparisonRulesetIds", "breakCodeSource", "primarySchedule"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateGroupReconciliationDefinitionRequest:
        """Create an instance of UpdateGroupReconciliationDefinitionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio_entity_ids
        if self.portfolio_entity_ids:
            _dict['portfolioEntityIds'] = self.portfolio_entity_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recipe_ids
        if self.recipe_ids:
            _dict['recipeIds'] = self.recipe_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currencies
        if self.currencies:
            _dict['currencies'] = self.currencies.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transaction_date_windows
        if self.transaction_date_windows:
            _dict['transactionDateWindows'] = self.transaction_date_windows.to_dict()
        # override the default output from pydantic by calling `to_dict()` of comparison_ruleset_ids
        if self.comparison_ruleset_ids:
            _dict['comparisonRulesetIds'] = self.comparison_ruleset_ids.to_dict()
        # override the default output from pydantic by calling `to_dict()` of break_code_source
        if self.break_code_source:
            _dict['breakCodeSource'] = self.break_code_source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primary_schedule
        if self.primary_schedule:
            _dict['primarySchedule'] = self.primary_schedule.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateGroupReconciliationDefinitionRequest:
        """Create an instance of UpdateGroupReconciliationDefinitionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateGroupReconciliationDefinitionRequest.parse_obj(obj)

        _obj = UpdateGroupReconciliationDefinitionRequest.parse_obj({
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "portfolio_entity_ids": GroupReconciliationDefinitionPortfolioEntityIds.from_dict(obj.get("portfolioEntityIds")) if obj.get("portfolioEntityIds") is not None else None,
            "recipe_ids": GroupReconciliationDefinitionRecipeIds.from_dict(obj.get("recipeIds")) if obj.get("recipeIds") is not None else None,
            "currencies": GroupReconciliationDefinitionCurrencies.from_dict(obj.get("currencies")) if obj.get("currencies") is not None else None,
            "transaction_date_windows": TransactionDateWindows.from_dict(obj.get("transactionDateWindows")) if obj.get("transactionDateWindows") is not None else None,
            "comparison_ruleset_ids": GroupReconciliationDefinitionComparisonRulesetIds.from_dict(obj.get("comparisonRulesetIds")) if obj.get("comparisonRulesetIds") is not None else None,
            "break_code_source": BreakCodeSource.from_dict(obj.get("breakCodeSource")) if obj.get("breakCodeSource") is not None else None,
            "primary_schedule": PrimarySchedule.from_dict(obj.get("primarySchedule")) if obj.get("primarySchedule") is not None else None
        })
        return _obj

UpdateGroupReconciliationDefinitionRequest.update_forward_refs()
