# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.relational_dataset_field_definition import RelationalDatasetFieldDefinition

class UpdateRelationalDatasetDefinitionRequest(BaseModel):
    """
    UpdateRelationalDatasetDefinitionRequest
    """
    display_name:  StrictStr = Field(...,alias="displayName", description="A user-friendly display name for the relational dataset definition.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A detailed description of the relational dataset definition and its purpose.") 
    applicable_entity_types: List[StrictStr] = Field(description="The types of entities this relational dataset definition can be applied to (e.g. Instrument, Portfolio, etc.).", alias="applicableEntityTypes")
    field_schema: List[RelationalDatasetFieldDefinition] = Field(description="The schema defining the structure and data types of the relational dataset.", alias="fieldSchema")
    __properties = ["displayName", "description", "applicableEntityTypes", "fieldSchema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateRelationalDatasetDefinitionRequest:
        """Create an instance of UpdateRelationalDatasetDefinitionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in field_schema (list)
        _items = []
        if self.field_schema:
            for _item in self.field_schema:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fieldSchema'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateRelationalDatasetDefinitionRequest:
        """Create an instance of UpdateRelationalDatasetDefinitionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateRelationalDatasetDefinitionRequest.parse_obj(obj)

        _obj = UpdateRelationalDatasetDefinitionRequest.parse_obj({
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "applicable_entity_types": obj.get("applicableEntityTypes"),
            "field_schema": [RelationalDatasetFieldDefinition.from_dict(_item) for _item in obj.get("fieldSchema")] if obj.get("fieldSchema") is not None else None
        })
        return _obj

UpdateRelationalDatasetDefinitionRequest.update_forward_refs()
