# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.applicable_entity_types import ApplicableEntityTypes

class UpdateRelationalDatasetDetails(BaseModel):
    """
    UpdateRelationalDatasetDetails
    """
    display_name:  StrictStr = Field(...,alias="displayName", description="A user-friendly display name for the relational dataset definition.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A detailed description of the relational dataset definition and its purpose.") 
    applicable_entity_types: Optional[ApplicableEntityTypes] = Field(default=None, alias="applicableEntityTypes")
    __properties = ["displayName", "description", "applicableEntityTypes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateRelationalDatasetDetails:
        """Create an instance of UpdateRelationalDatasetDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of applicable_entity_types
        if self.applicable_entity_types:
            _dict['applicableEntityTypes'] = self.applicable_entity_types.to_dict()
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateRelationalDatasetDetails:
        """Create an instance of UpdateRelationalDatasetDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateRelationalDatasetDetails.parse_obj(obj)

        _obj = UpdateRelationalDatasetDetails.parse_obj({
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "applicable_entity_types": ApplicableEntityTypes.from_dict(obj.get("applicableEntityTypes")) if obj.get("applicableEntityTypes") is not None else None
        })
        return _obj

UpdateRelationalDatasetDetails.update_forward_refs()
