# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.compliance_parameter import ComplianceParameter
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.resource_id import ResourceId

class UpsertComplianceRuleRequest(BaseModel):
    """
    UpsertComplianceRuleRequest
    """
    id: ResourceId
    name:  Optional[StrictStr] = Field(None,alias="name") 
    description:  Optional[StrictStr] = Field(None,alias="description") 
    active: StrictBool
    template_id: ResourceId = Field(alias="templateId")
    variation:  StrictStr = Field(...,alias="variation") 
    portfolio_group_id: ResourceId = Field(alias="portfolioGroupId")
    parameters: Dict[str, ComplianceParameter]
    properties: Dict[str, PerpetualProperty]
    __properties = ["id", "name", "description", "active", "templateId", "variation", "portfolioGroupId", "parameters", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertComplianceRuleRequest:
        """Create an instance of UpsertComplianceRuleRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of template_id
        if self.template_id:
            _dict['templateId'] = self.template_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of portfolio_group_id
        if self.portfolio_group_id:
            _dict['portfolioGroupId'] = self.portfolio_group_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in parameters (dict)
        _field_dict = {}
        if self.parameters:
            for _key in self.parameters:
                if self.parameters[_key]:
                    _field_dict[_key] = self.parameters[_key].to_dict()
            _dict['parameters'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertComplianceRuleRequest:
        """Create an instance of UpsertComplianceRuleRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertComplianceRuleRequest.parse_obj(obj)

        _obj = UpsertComplianceRuleRequest.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "active": obj.get("active"),
            "template_id": ResourceId.from_dict(obj.get("templateId")) if obj.get("templateId") is not None else None,
            "variation": obj.get("variation"),
            "portfolio_group_id": ResourceId.from_dict(obj.get("portfolioGroupId")) if obj.get("portfolioGroupId") is not None else None,
            "parameters": dict(
                (_k, ComplianceParameter.from_dict(_v))
                for _k, _v in obj.get("parameters").items()
            )
            if obj.get("parameters") is not None
            else None,
            "properties": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None
        })
        return _obj

UpsertComplianceRuleRequest.update_forward_refs()
