# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.compliance_summary_rule_result_request import ComplianceSummaryRuleResultRequest
from lusid.models.resource_id import ResourceId

class UpsertComplianceRunSummaryRequest(BaseModel):
    """
    UpsertComplianceRunSummaryRequest
    """
    run_id: ResourceId = Field(alias="runId")
    instigated_at: datetime = Field(alias="instigatedAt")
    completed_at: datetime = Field(alias="completedAt")
    schedule:  StrictStr = Field(...,alias="schedule") 
    results: List[ComplianceSummaryRuleResultRequest]
    __properties = ["runId", "instigatedAt", "completedAt", "schedule", "results"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertComplianceRunSummaryRequest:
        """Create an instance of UpsertComplianceRunSummaryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of run_id
        if self.run_id:
            _dict['runId'] = self.run_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item in self.results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['results'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertComplianceRunSummaryRequest:
        """Create an instance of UpsertComplianceRunSummaryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertComplianceRunSummaryRequest.parse_obj(obj)

        _obj = UpsertComplianceRunSummaryRequest.parse_obj({
            "run_id": ResourceId.from_dict(obj.get("runId")) if obj.get("runId") is not None else None,
            "instigated_at": obj.get("instigatedAt"),
            "completed_at": obj.get("completedAt"),
            "schedule": obj.get("schedule"),
            "results": [ComplianceSummaryRuleResultRequest.from_dict(_item) for _item in obj.get("results")] if obj.get("results") is not None else None
        })
        return _obj

UpsertComplianceRunSummaryRequest.update_forward_refs()
