# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.dialect_id import DialectId
from lusid.models.dialect_schema import DialectSchema

class UpsertDialectRequest(BaseModel):
    """
    UpsertDialectRequest
    """
    id: DialectId
    var_schema: DialectSchema = Field(alias="schema")
    __properties = ["id", "schema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertDialectRequest:
        """Create an instance of UpsertDialectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of var_schema
        if self.var_schema:
            _dict['schema'] = self.var_schema.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertDialectRequest:
        """Create an instance of UpsertDialectRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertDialectRequest.parse_obj(obj)

        _obj = UpsertDialectRequest.parse_obj({
            "id": DialectId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "var_schema": DialectSchema.from_dict(obj.get("schema")) if obj.get("schema") is not None else None
        })
        return _obj

UpsertDialectRequest.update_forward_refs()
