# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.model_property import ModelProperty

class UpsertFundBookmarkRequest(BaseModel):
    """
    A definition for the period you wish to close  # noqa: E501
    """
    bookmark_code:  StrictStr = Field(...,alias="bookmarkCode", description="Unique code for the Bookmark.") 
    display_name:  StrictStr = Field(...,alias="displayName", description="Identifiable Name assigned to the Bookmark.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="Description assigned to the Bookmark.") 
    effective_at: datetime = Field(description="The effective time of the Bookmark.", alias="effectiveAt")
    query_as_at: Optional[datetime] = Field(default=None, description="The query time of the Bookmark. Defaults to latest.", alias="queryAsAt")
    properties: Optional[Dict[str, ModelProperty]] = Field(default=None, description="A set of properties for the Bookmark.")
    __properties = ["bookmarkCode", "displayName", "description", "effectiveAt", "queryAsAt", "properties"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertFundBookmarkRequest:
        """Create an instance of UpsertFundBookmarkRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if query_as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.query_as_at is None and "query_as_at" in self.__fields_set__:
            _dict['queryAsAt'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertFundBookmarkRequest:
        """Create an instance of UpsertFundBookmarkRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertFundBookmarkRequest.parse_obj(obj)

        _obj = UpsertFundBookmarkRequest.parse_obj({
            "bookmark_code": obj.get("bookmarkCode"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "effective_at": obj.get("effectiveAt"),
            "query_as_at": obj.get("queryAsAt"),
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None
        })
        return _obj

UpsertFundBookmarkRequest.update_forward_refs()
