# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.reference_portfolio_constituent_request import ReferencePortfolioConstituentRequest

class UpsertReferencePortfolioConstituentsRequest(BaseModel):
    """
    UpsertReferencePortfolioConstituentsRequest
    """
    effective_from:  StrictStr = Field(...,alias="effectiveFrom", description="The first date from which the weights will apply") 
    weight_type:  StrictStr = Field(...,alias="weightType", description="The available values are: Static, Floating, Periodical") 
    period_type:  Optional[StrictStr] = Field(None,alias="periodType", description="The available values are: Daily, Weekly, Monthly, Quarterly, Annually") 
    period_count: Optional[StrictInt] = Field(default=None, alias="periodCount")
    constituents: List[ReferencePortfolioConstituentRequest] = Field(description="Set of constituents (instrument/weight pairings)")
    __properties = ["effectiveFrom", "weightType", "periodType", "periodCount", "constituents"]

    @validator('weight_type')
    def weight_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'UpsertReferencePortfolioConstituentsRequest' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "weight_type" != "type":
            return value

        if value not in ['Static', 'Floating', 'Periodical']:
            raise ValueError("must be one of enum values ('Static', 'Floating', 'Periodical')")
        return value

    @validator('period_type')
    def period_type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'UpsertReferencePortfolioConstituentsRequest' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "period_type" != "type":
            return value

        if value is None:
            return value

        if value not in ['Daily', 'Weekly', 'Monthly', 'Quarterly', 'Annually']:
            raise ValueError("must be one of enum values ('Daily', 'Weekly', 'Monthly', 'Quarterly', 'Annually')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertReferencePortfolioConstituentsRequest:
        """Create an instance of UpsertReferencePortfolioConstituentsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in constituents (list)
        _items = []
        if self.constituents:
            for _item in self.constituents:
                if _item:
                    _items.append(_item.to_dict())
            _dict['constituents'] = _items
        # set to None if period_type (nullable) is None
        # and __fields_set__ contains the field
        if self.period_type is None and "period_type" in self.__fields_set__:
            _dict['periodType'] = None

        # set to None if period_count (nullable) is None
        # and __fields_set__ contains the field
        if self.period_count is None and "period_count" in self.__fields_set__:
            _dict['periodCount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertReferencePortfolioConstituentsRequest:
        """Create an instance of UpsertReferencePortfolioConstituentsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertReferencePortfolioConstituentsRequest.parse_obj(obj)

        _obj = UpsertReferencePortfolioConstituentsRequest.parse_obj({
            "effective_from": obj.get("effectiveFrom"),
            "weight_type": obj.get("weightType"),
            "period_type": obj.get("periodType"),
            "period_count": obj.get("periodCount"),
            "constituents": [ReferencePortfolioConstituentRequest.from_dict(_item) for _item in obj.get("constituents")] if obj.get("constituents") is not None else None
        })
        return _obj

UpsertReferencePortfolioConstituentsRequest.update_forward_refs()
