# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.upsert_relational_data_point_data_series import UpsertRelationalDataPointDataSeries

class UpsertRelationalDataPointRequest(BaseModel):
    """
    UpsertRelationalDataPointRequest
    """
    data_point_data_series: UpsertRelationalDataPointDataSeries = Field(alias="dataPointDataSeries")
    effective_at:  StrictStr = Field(...,alias="effectiveAt", description="The effectiveAt or cut-label datetime of the DataPoint.") 
    value_fields: Dict[str, Any] = Field(description="The values associated with the DataPoint, structured according to the FieldSchema of the parent RelationalDatasetDefinition.", alias="valueFields")
    meta_data_fields: Optional[Dict[str, Any]] = Field(default=None, description="The metadata associated with the DataPoint, structured according to the FieldSchema of the parent RelationalDatasetDefinition.", alias="metaDataFields")
    __properties = ["dataPointDataSeries", "effectiveAt", "valueFields", "metaDataFields"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertRelationalDataPointRequest:
        """Create an instance of UpsertRelationalDataPointRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data_point_data_series
        if self.data_point_data_series:
            _dict['dataPointDataSeries'] = self.data_point_data_series.to_dict()
        # set to None if meta_data_fields (nullable) is None
        # and __fields_set__ contains the field
        if self.meta_data_fields is None and "meta_data_fields" in self.__fields_set__:
            _dict['metaDataFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertRelationalDataPointRequest:
        """Create an instance of UpsertRelationalDataPointRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertRelationalDataPointRequest.parse_obj(obj)

        _obj = UpsertRelationalDataPointRequest.parse_obj({
            "data_point_data_series": UpsertRelationalDataPointDataSeries.from_dict(obj.get("dataPointDataSeries")) if obj.get("dataPointDataSeries") is not None else None,
            "effective_at": obj.get("effectiveAt"),
            "value_fields": obj.get("valueFields"),
            "meta_data_fields": obj.get("metaDataFields")
        })
        return _obj

UpsertRelationalDataPointRequest.update_forward_refs()
