# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.result_value import ResultValue
from lusid.models.structured_result_data_id import StructuredResultDataId

class UpsertResultValuesDataRequest(BaseModel):
    """
    UpsertResultValuesDataRequest
    """
    document_id: StructuredResultDataId = Field(alias="documentId")
    key: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="The structured unit result data key.")
    data_address:  Optional[StrictStr] = Field(None,alias="dataAddress", description="The address of the piece of unit result data") 
    result_value: Optional[ResultValue] = Field(default=None, alias="resultValue")
    __properties = ["documentId", "key", "dataAddress", "resultValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpsertResultValuesDataRequest:
        """Create an instance of UpsertResultValuesDataRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of document_id
        if self.document_id:
            _dict['documentId'] = self.document_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of result_value
        if self.result_value:
            _dict['resultValue'] = self.result_value.to_dict()
        # set to None if key (nullable) is None
        # and __fields_set__ contains the field
        if self.key is None and "key" in self.__fields_set__:
            _dict['key'] = None

        # set to None if data_address (nullable) is None
        # and __fields_set__ contains the field
        if self.data_address is None and "data_address" in self.__fields_set__:
            _dict['dataAddress'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpsertResultValuesDataRequest:
        """Create an instance of UpsertResultValuesDataRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpsertResultValuesDataRequest.parse_obj(obj)

        _obj = UpsertResultValuesDataRequest.parse_obj({
            "document_id": StructuredResultDataId.from_dict(obj.get("documentId")) if obj.get("documentId") is not None else None,
            "key": obj.get("key"),
            "data_address": obj.get("dataAddress"),
            "result_value": ResultValue.from_dict(obj.get("resultValue")) if obj.get("resultValue") is not None else None
        })
        return _obj

UpsertResultValuesDataRequest.update_forward_refs()
