# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.address_key_filter import AddressKeyFilter
from lusid.models.model_options import ModelOptions

class VendorModelRule(BaseModel):
    """
    A rule that identifies the set of preferences to be used for a given library, model and instrument type.  There can be many such rules, though only the first found for a given combination would be used.  # noqa: E501
    """
    supplier:  StrictStr = Field(...,alias="supplier", description="The available values are: Lusid, RefinitivQps, RefinitivTracsWeb, VolMaster, IsdaCds, YieldBook, LusidCalc") 
    model_name:  StrictStr = Field(...,alias="modelName", description="The vendor library model name") 
    instrument_type:  StrictStr = Field(...,alias="instrumentType", description="The vendor library instrument type") 
    parameters:  Optional[StrictStr] = Field(None,alias="parameters", description="THIS FIELD IS DEPRECATED - use ModelOptions  The set of opaque model parameters, provided as a Json object, that is a string object which will internally be converted to a dictionary of string to object.  Note that this is not intended as the final form of this object. It will be replaced with a more structured object as the set of parameters that are possible is  better understood.") 
    model_options: Optional[ModelOptions] = Field(default=None, alias="modelOptions")
    instrument_id:  Optional[StrictStr] = Field(None,alias="instrumentId", description="This field should generally not be required. It indicates a specific case where there is a particular need to make a rule apply to only a single instrument  specified by an identifier on that instrument such as its LUID. One particular example would be to control the behaviour of a look-through portfolio scaling  methodology, such as where there is a mixture of indices and credit-debit portfolios where scaling on the sum of valuation would be deemed incorrectly for one  set but desired in general.") 
    address_key_filters: Optional[List[AddressKeyFilter]] = Field(default=None, description="Condition for model selection. If a condition is satisfied the default model for valuation is overridden (for that instrument).", alias="addressKeyFilters")
    __properties = ["supplier", "modelName", "instrumentType", "parameters", "modelOptions", "instrumentId", "addressKeyFilters"]

    @validator('supplier')
    def supplier_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'VendorModelRule' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse',
                                    'Library',
                                    'LibraryResponse',
                                    'DayRegularity',
                                    'RelativeMonthRegularity',
                                    'SpecificMonthRegularity',
                                    'WeekRegularity',
                                    'YearRegularity']:
           return value
        
        # Only validate the 'type' property of the class
        if "supplier" != "type":
            return value

        if value not in ['Lusid', 'RefinitivQps', 'RefinitivTracsWeb', 'VolMaster', 'IsdaCds', 'YieldBook', 'LusidCalc']:
            raise ValueError("must be one of enum values ('Lusid', 'RefinitivQps', 'RefinitivTracsWeb', 'VolMaster', 'IsdaCds', 'YieldBook', 'LusidCalc')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VendorModelRule:
        """Create an instance of VendorModelRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of model_options
        if self.model_options:
            _dict['modelOptions'] = self.model_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in address_key_filters (list)
        _items = []
        if self.address_key_filters:
            for _item in self.address_key_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addressKeyFilters'] = _items
        # set to None if parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.parameters is None and "parameters" in self.__fields_set__:
            _dict['parameters'] = None

        # set to None if instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_id is None and "instrument_id" in self.__fields_set__:
            _dict['instrumentId'] = None

        # set to None if address_key_filters (nullable) is None
        # and __fields_set__ contains the field
        if self.address_key_filters is None and "address_key_filters" in self.__fields_set__:
            _dict['addressKeyFilters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VendorModelRule:
        """Create an instance of VendorModelRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VendorModelRule.parse_obj(obj)

        _obj = VendorModelRule.parse_obj({
            "supplier": obj.get("supplier"),
            "model_name": obj.get("modelName"),
            "instrument_type": obj.get("instrumentType"),
            "parameters": obj.get("parameters"),
            "model_options": ModelOptions.from_dict(obj.get("modelOptions")) if obj.get("modelOptions") is not None else None,
            "instrument_id": obj.get("instrumentId"),
            "address_key_filters": [AddressKeyFilter.from_dict(_item) for _item in obj.get("addressKeyFilters")] if obj.get("addressKeyFilters") is not None else None
        })
        return _obj

VendorModelRule.update_forward_refs()
