# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from lusid.models.link import Link
from lusid.models.settlement_instruction_query import SettlementInstructionQuery
from lusid.models.settlement_instruction_with_transaction import SettlementInstructionWithTransaction
from lusid.models.version import Version

class VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery(BaseModel):
    """
    VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery
    """
    version: Version
    values: List[SettlementInstructionWithTransaction] = Field(description="The resources to list.")
    href:  Optional[StrictStr] = Field(None,alias="href", description="The URI of the resource list.") 
    post_body: Optional[SettlementInstructionQuery] = Field(default=None, alias="postBody")
    next_page: Optional[SettlementInstructionQuery] = Field(default=None, alias="nextPage")
    previous_page: Optional[SettlementInstructionQuery] = Field(default=None, alias="previousPage")
    links: Optional[List[Link]] = None
    __properties = ["version", "values", "href", "postBody", "nextPage", "previousPage", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery:
        """Create an instance of VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in values (list)
        _items = []
        if self.values:
            for _item in self.values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['values'] = _items
        # override the default output from pydantic by calling `to_dict()` of post_body
        if self.post_body:
            _dict['postBody'] = self.post_body.to_dict()
        # override the default output from pydantic by calling `to_dict()` of next_page
        if self.next_page:
            _dict['nextPage'] = self.next_page.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_page
        if self.previous_page:
            _dict['previousPage'] = self.previous_page.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery:
        """Create an instance of VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery.parse_obj(obj)

        _obj = VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery.parse_obj({
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "values": [SettlementInstructionWithTransaction.from_dict(_item) for _item in obj.get("values")] if obj.get("values") is not None else None,
            "href": obj.get("href"),
            "post_body": SettlementInstructionQuery.from_dict(obj.get("postBody")) if obj.get("postBody") is not None else None,
            "next_page": SettlementInstructionQuery.from_dict(obj.get("nextPage")) if obj.get("nextPage") is not None else None,
            "previous_page": SettlementInstructionQuery.from_dict(obj.get("previousPage")) if obj.get("previousPage") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

VersionedResourceListWithPostBodiesOfSettlementInstructionWithTransactionToSettlementInstructionQuery.update_forward_refs()
